/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.plugin.annotation;

import com.mycila.log.Logger;
import com.mycila.log.Loggers;
import com.mycila.testing.core.api.TestExecution;
import com.mycila.testing.core.plugin.DefaultTestPlugin;
import com.mycila.testing.ea.Code;
import com.mycila.testing.ea.ExtendedAssert;
import com.mycila.testing.plugin.annotation.ExpectException;
import com.mycila.testing.plugin.annotation.Skip;

public final class AnnotationTestPlugin
extends DefaultTestPlugin {
    private static final Logger LOGGER = Loggers.get(AnnotationTestPlugin.class);

    public void beforeTest(TestExecution testExecution) throws Exception {
        if (testExecution.method().isAnnotationPresent(Skip.class) || testExecution.context().introspector().hasAnnotation(Skip.class)) {
            LOGGER.debug((Object)"Skipping test method %s.%s", new Object[]{testExecution.method().getDeclaringClass().getName(), testExecution.method().getName()});
            testExecution.setSkip(true);
        }
    }

    public void afterTest(final TestExecution testExecution) throws Exception {
        ExpectException expectException = testExecution.method().getAnnotation(ExpectException.class);
        if (!testExecution.mustSkip() && expectException != null) {
            ExtendedAssert.AssertException assertException = ExtendedAssert.assertThrow(expectException.type());
            if (!"com.mycila.testing.plugin.annotation.ExpectException.NO_MESSAGE".equals(expectException.message())) {
                assertException.withMessage(expectException.message());
            } else if (!"com.mycila.testing.plugin.annotation.ExpectException.NO_MESSAGE".equals(expectException.containing())) {
                assertException.containingMessage(expectException.containing());
            }
            try {
                assertException.whenRunning(new Code(){

                    public void run() throws Throwable {
                        if (testExecution.hasFailed()) {
                            throw testExecution.throwable();
                        }
                    }
                });
                testExecution.setThrowable(null);
            }
            catch (Throwable e) {
                testExecution.setThrowable(e);
            }
        }
    }
}

