/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.SiteSource;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SiteSourceRequest
extends BaseRequest<SiteSource> {
    public SiteSourceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SiteSource.class);
    }

    @Nonnull
    public CompletableFuture<SiteSource> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public SiteSource get() throws ClientException {
        return (SiteSource)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<SiteSource> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public SiteSource delete() throws ClientException {
        return (SiteSource)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<SiteSource> patchAsync(@Nonnull SiteSource sourceSiteSource) {
        return this.sendAsync(HttpMethod.PATCH, sourceSiteSource);
    }

    @Nullable
    public SiteSource patch(@Nonnull SiteSource sourceSiteSource) throws ClientException {
        return (SiteSource)this.send(HttpMethod.PATCH, sourceSiteSource);
    }

    @Nonnull
    public CompletableFuture<SiteSource> postAsync(@Nonnull SiteSource newSiteSource) {
        return this.sendAsync(HttpMethod.POST, newSiteSource);
    }

    @Nullable
    public SiteSource post(@Nonnull SiteSource newSiteSource) throws ClientException {
        return (SiteSource)this.send(HttpMethod.POST, newSiteSource);
    }

    @Nonnull
    public CompletableFuture<SiteSource> putAsync(@Nonnull SiteSource newSiteSource) {
        return this.sendAsync(HttpMethod.PUT, newSiteSource);
    }

    @Nullable
    public SiteSource put(@Nonnull SiteSource newSiteSource) throws ClientException {
        return (SiteSource)this.send(HttpMethod.PUT, newSiteSource);
    }

    @Nonnull
    public SiteSourceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SiteSourceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

