/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Synchronization;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SynchronizationRequest
extends BaseRequest<Synchronization> {
    public SynchronizationRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Synchronization.class);
    }

    @Nonnull
    public CompletableFuture<Synchronization> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Synchronization get() throws ClientException {
        return (Synchronization)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Synchronization> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Synchronization delete() throws ClientException {
        return (Synchronization)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Synchronization> patchAsync(@Nonnull Synchronization sourceSynchronization) {
        return this.sendAsync(HttpMethod.PATCH, sourceSynchronization);
    }

    @Nullable
    public Synchronization patch(@Nonnull Synchronization sourceSynchronization) throws ClientException {
        return (Synchronization)this.send(HttpMethod.PATCH, sourceSynchronization);
    }

    @Nonnull
    public CompletableFuture<Synchronization> postAsync(@Nonnull Synchronization newSynchronization) {
        return this.sendAsync(HttpMethod.POST, newSynchronization);
    }

    @Nullable
    public Synchronization post(@Nonnull Synchronization newSynchronization) throws ClientException {
        return (Synchronization)this.send(HttpMethod.POST, newSynchronization);
    }

    @Nonnull
    public CompletableFuture<Synchronization> putAsync(@Nonnull Synchronization newSynchronization) {
        return this.sendAsync(HttpMethod.PUT, newSynchronization);
    }

    @Nullable
    public Synchronization put(@Nonnull Synchronization newSynchronization) throws ClientException {
        return (Synchronization)this.send(HttpMethod.PUT, newSynchronization);
    }

    @Nonnull
    public SynchronizationRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SynchronizationRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

