/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Payload;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PayloadRequest
extends BaseRequest<Payload> {
    public PayloadRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Payload.class);
    }

    @Nonnull
    public CompletableFuture<Payload> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Payload get() throws ClientException {
        return (Payload)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Payload> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Payload delete() throws ClientException {
        return (Payload)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Payload> patchAsync(@Nonnull Payload sourcePayload) {
        return this.sendAsync(HttpMethod.PATCH, sourcePayload);
    }

    @Nullable
    public Payload patch(@Nonnull Payload sourcePayload) throws ClientException {
        return (Payload)this.send(HttpMethod.PATCH, sourcePayload);
    }

    @Nonnull
    public CompletableFuture<Payload> postAsync(@Nonnull Payload newPayload) {
        return this.sendAsync(HttpMethod.POST, newPayload);
    }

    @Nullable
    public Payload post(@Nonnull Payload newPayload) throws ClientException {
        return (Payload)this.send(HttpMethod.POST, newPayload);
    }

    @Nonnull
    public CompletableFuture<Payload> putAsync(@Nonnull Payload newPayload) {
        return this.sendAsync(HttpMethod.PUT, newPayload);
    }

    @Nullable
    public Payload put(@Nonnull Payload newPayload) throws ClientException {
        return (Payload)this.send(HttpMethod.PUT, newPayload);
    }

    @Nonnull
    public PayloadRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PayloadRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

