/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.PrintJob;
import com.microsoft.graph.models.PrintJobAbortParameterSet;
import com.microsoft.graph.models.PrintJobRedirectParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.PrintDocumentCollectionRequestBuilder;
import com.microsoft.graph.requests.PrintDocumentRequestBuilder;
import com.microsoft.graph.requests.PrintJobAbortRequestBuilder;
import com.microsoft.graph.requests.PrintJobCancelRequestBuilder;
import com.microsoft.graph.requests.PrintJobRedirectRequestBuilder;
import com.microsoft.graph.requests.PrintJobRequest;
import com.microsoft.graph.requests.PrintJobStartRequestBuilder;
import com.microsoft.graph.requests.PrintTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.PrintTaskRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrintJobRequestBuilder
extends BaseRequestBuilder<PrintJob> {
    public PrintJobRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public PrintJobRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public PrintJobRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new PrintJobRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public PrintDocumentCollectionRequestBuilder documents() {
        return new PrintDocumentCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("documents"), this.getClient(), null);
    }

    @Nonnull
    public PrintDocumentRequestBuilder documents(@Nonnull String id) {
        return new PrintDocumentRequestBuilder(this.getRequestUrlWithAdditionalSegment("documents") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public PrintTaskCollectionRequestBuilder tasks() {
        return new PrintTaskCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("tasks"), this.getClient(), null);
    }

    @Nonnull
    public PrintTaskRequestBuilder tasks(@Nonnull String id) {
        return new PrintTaskRequestBuilder(this.getRequestUrlWithAdditionalSegment("tasks") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public PrintJobCancelRequestBuilder cancel() {
        return new PrintJobCancelRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.cancel"), this.getClient(), null);
    }

    @Nonnull
    public PrintJobStartRequestBuilder start() {
        return new PrintJobStartRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.start"), this.getClient(), null);
    }

    @Nonnull
    public PrintJobAbortRequestBuilder abort(@Nonnull PrintJobAbortParameterSet parameters) {
        return new PrintJobAbortRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.abort"), this.getClient(), null, parameters);
    }

    @Nonnull
    public PrintJobRedirectRequestBuilder redirect(@Nonnull PrintJobRedirectParameterSet parameters) {
        return new PrintJobRedirectRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.redirect"), this.getClient(), null, parameters);
    }
}

