/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Authentication;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuthenticationRequest
extends BaseRequest<Authentication> {
    public AuthenticationRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Authentication.class);
    }

    @Nonnull
    public CompletableFuture<Authentication> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Authentication get() throws ClientException {
        return (Authentication)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Authentication> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Authentication delete() throws ClientException {
        return (Authentication)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Authentication> patchAsync(@Nonnull Authentication sourceAuthentication) {
        return this.sendAsync(HttpMethod.PATCH, sourceAuthentication);
    }

    @Nullable
    public Authentication patch(@Nonnull Authentication sourceAuthentication) throws ClientException {
        return (Authentication)this.send(HttpMethod.PATCH, sourceAuthentication);
    }

    @Nonnull
    public CompletableFuture<Authentication> postAsync(@Nonnull Authentication newAuthentication) {
        return this.sendAsync(HttpMethod.POST, newAuthentication);
    }

    @Nullable
    public Authentication post(@Nonnull Authentication newAuthentication) throws ClientException {
        return (Authentication)this.send(HttpMethod.POST, newAuthentication);
    }

    @Nonnull
    public CompletableFuture<Authentication> putAsync(@Nonnull Authentication newAuthentication) {
        return this.sendAsync(HttpMethod.PUT, newAuthentication);
    }

    @Nullable
    public Authentication put(@Nonnull Authentication newAuthentication) throws ClientException {
        return (Authentication)this.send(HttpMethod.PUT, newAuthentication);
    }

    @Nonnull
    public AuthenticationRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AuthenticationRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

