/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.view;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IView {
    public void dispose();

    public void refresh();

    public static interface Label
    extends IView {
        public String getLabel();

        public String getIconPath();

        public String getDescription();

        default public boolean isEnabled() {
            return true;
        }

        @Override
        default public void refresh() {
        }

        public static class Static
        implements Label {
            @Nonnull
            protected final String label;
            @Nullable
            protected String iconPath;
            @Nullable
            protected String description;

            public Static(String title, String iconPath) {
                this(title, iconPath, null);
            }

            @Override
            public void dispose() {
            }

            @Override
            @Nonnull
            public String getLabel() {
                return this.label;
            }

            @Override
            @Nullable
            public String getIconPath() {
                return this.iconPath;
            }

            @Override
            @Nullable
            public String getDescription() {
                return this.description;
            }

            public Static(@Nonnull String label) {
                if (label == null) {
                    throw new NullPointerException("label is marked non-null but is null");
                }
                this.label = label;
            }

            public Static(@Nonnull String label, @Nullable String iconPath, @Nullable String description) {
                if (label == null) {
                    throw new NullPointerException("label is marked non-null but is null");
                }
                this.label = label;
                this.iconPath = iconPath;
                this.description = description;
            }
        }
    }
}

