/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.gremlin;

import com.microsoft.azure.spring.autoconfigure.gremlin.GremlinProperties;
import com.microsoft.azure.telemetry.TelemetryData;
import com.microsoft.azure.telemetry.TelemetrySender;
import com.microsoft.spring.data.gremlin.common.GremlinConfig;
import com.microsoft.spring.data.gremlin.common.GremlinFactory;
import com.microsoft.spring.data.gremlin.conversion.MappingGremlinConverter;
import com.microsoft.spring.data.gremlin.mapping.GremlinMappingContext;
import com.microsoft.spring.data.gremlin.query.GremlinTemplate;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.domain.EntityScanner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnClass(value={GremlinFactory.class, GremlinTemplate.class, MappingGremlinConverter.class})
@ConditionalOnResource(resources={"classpath:gremlin.enable.config"})
@ConditionalOnProperty(prefix="gremlin", value={"endpoint", "port", "username", "password"})
@EnableConfigurationProperties(value={GremlinProperties.class})
public class GremlinAutoConfiguration {
    private final GremlinProperties properties;
    private final ApplicationContext applicationContext;

    public GremlinAutoConfiguration(@NonNull GremlinProperties properties, @NonNull ApplicationContext context) {
        this.properties = properties;
        this.applicationContext = context;
    }

    @PostConstruct
    private void sendTelemetry() {
        if (this.properties.isTelemetryAllowed()) {
            HashMap<String, String> events = new HashMap<String, String>();
            TelemetrySender sender = new TelemetrySender();
            events.put("serviceName", TelemetryData.getClassPackageSimpleName(GremlinAutoConfiguration.class));
            sender.send(ClassUtils.getUserClass(this.getClass()).getSimpleName(), events);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public GremlinConfig getGremlinConfig() {
        return GremlinConfig.builder((String)this.properties.getEndpoint(), (String)this.properties.getUsername(), (String)this.properties.getPassword()).port(this.properties.getPort()).sslEnabled(this.properties.isSslEnabled()).telemetryAllowed(this.properties.isTelemetryAllowed()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public GremlinFactory gremlinFactory() {
        return new GremlinFactory(this.getGremlinConfig());
    }

    @Bean
    @ConditionalOnMissingBean
    public GremlinTemplate gremlinTemplate(GremlinFactory factory, MappingGremlinConverter converter) {
        return new GremlinTemplate(factory, converter);
    }

    @Bean
    @ConditionalOnMissingBean
    public GremlinMappingContext gremlinMappingContext() {
        try {
            GremlinMappingContext context = new GremlinMappingContext();
            context.setInitialEntitySet(new EntityScanner(this.applicationContext).scan(new Class[]{Persistent.class}));
            return context;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public MappingGremlinConverter mappingGremlinConverter(GremlinMappingContext context) {
        return new MappingGremlinConverter((MappingContext)context);
    }
}

