/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.gremlin;

import com.microsoft.azure.spring.autoconfigure.gremlin.GremlinProperties;
import com.microsoft.azure.telemetry.TelemetryProxy;
import com.microsoft.spring.data.gremlin.common.GremlinFactory;
import com.microsoft.spring.data.gremlin.conversion.MappingGremlinConverter;
import com.microsoft.spring.data.gremlin.mapping.GremlinMappingContext;
import com.microsoft.spring.data.gremlin.query.GremlinTemplate;
import java.util.HashMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScanner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnClass(value={GremlinFactory.class, GremlinTemplate.class, MappingGremlinConverter.class})
@ConditionalOnProperty(prefix="gremlin", value={"endpoint", "port", "username", "password"})
@EnableConfigurationProperties(value={GremlinProperties.class})
public class GremlinAutoConfiguration {
    private final GremlinProperties properties;
    private final TelemetryProxy telemetryProxy;
    private final ApplicationContext applicationContext;

    public GremlinAutoConfiguration(@NonNull GremlinProperties properties, @NonNull ApplicationContext context) {
        this.properties = properties;
        this.applicationContext = context;
        this.telemetryProxy = new TelemetryProxy(properties.isTelemetryAllowed());
    }

    private void trackCustomEvent() {
        HashMap<String, String> customTelemetryProperties = new HashMap<String, String>();
        String[] packageNames = this.getClass().getPackage().getName().split("\\.");
        if (packageNames.length > 1) {
            customTelemetryProperties.put("serviceName", packageNames[packageNames.length - 1]);
        }
        this.telemetryProxy.trackEvent(ClassUtils.getUserClass(this.getClass()).getSimpleName(), customTelemetryProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public GremlinFactory gremlinFactory() {
        this.trackCustomEvent();
        String endpoint = this.properties.getEndpoint();
        String port = this.properties.getPort();
        String username = this.properties.getUsername();
        String password = this.properties.getPassword();
        return new GremlinFactory(endpoint, port, username, password);
    }

    @Bean
    @ConditionalOnMissingBean
    public GremlinTemplate gremlinTemplate(GremlinFactory factory, MappingGremlinConverter converter) {
        return new GremlinTemplate(factory, converter);
    }

    @Bean
    @ConditionalOnMissingBean
    public GremlinMappingContext gremlinMappingContext() {
        try {
            GremlinMappingContext context = new GremlinMappingContext();
            context.setInitialEntitySet(new EntityScanner(this.applicationContext).scan(new Class[]{Persistent.class}));
            return context;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public MappingGremlinConverter mappingGremlinConverter(GremlinMappingContext context) {
        return new MappingGremlinConverter((MappingContext)context);
    }
}

