/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHandler
extends BaseHandler {
    protected static final Logger TRACE_LOGGER = LoggerFactory.getLogger(SessionHandler.class);
    private final String name;

    public SessionHandler(String name) {
        this.name = name;
    }

    public void onSessionRemoteOpen(Event e) {
        TRACE_LOGGER.debug("onSessionRemoteOpen - entityName: {}, sessionIncCapacity: {}, sessionOutgoingWindow: {}", new Object[]{this.name, e.getSession().getIncomingCapacity(), e.getSession().getOutgoingWindow()});
        Session session = e.getSession();
        if (session != null && session.getLocalState() == EndpointState.UNINITIALIZED) {
            session.open();
        }
    }

    public void onSessionLocalClose(Event e) {
        TRACE_LOGGER.debug("onSessionLocalClose - entityName: {}, condition: {}", (Object)this.name, (Object)(e.getSession().getCondition() == null ? "none" : e.getSession().getCondition().toString()));
    }

    public void onSessionRemoteClose(Event e) {
        TRACE_LOGGER.debug("onSessionRemoteClose - entityName: {}, condition: {}", (Object)this.name, (Object)(e.getSession().getCondition() == null ? "none" : e.getSession().getCondition().toString()));
        Session session = e.getSession();
        if (session != null && session.getLocalState() != EndpointState.CLOSED) {
            session.close();
        }
    }

    public void onSessionFinal(Event e) {
        TRACE_LOGGER.debug("onSessionFinal - entityName: {}", (Object)this.name);
    }
}

