/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.httputils;

import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.Validate;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.Experimental;
import com.microsoft.applicationinsights.web.internal.httputils.HttpExtractor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Experimental
public class ApplicationInsightsServletExtractor
implements HttpExtractor<HttpServletRequest, HttpServletResponse> {
    private static final String USER_AGENT_HEADER = "User-Agent";

    @Override
    public String getUrl(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    @Override
    public String getMethod(HttpServletRequest request) {
        return request.getMethod();
    }

    @Override
    public String getHost(HttpServletRequest request) {
        return request.getServerName() + ":" + request.getServerPort();
    }

    @Override
    public String getQuery(HttpServletRequest request) {
        return request.getQueryString();
    }

    @Override
    public String getPath(HttpServletRequest request) {
        return request.getPathInfo();
    }

    @Override
    public String getUserAgent(HttpServletRequest request) {
        return request.getHeader(USER_AGENT_HEADER);
    }

    @Override
    public int getStatusCode(HttpServletResponse response) {
        if (response != null) {
            return response.getStatus();
        }
        return 0;
    }

    @Override
    public String getUri(HttpServletRequest request) {
        return this.removeSessionIdFromUri(request.getRequestURI());
    }

    @Override
    public String getScheme(HttpServletRequest request) {
        return request.getScheme();
    }

    private String removeSessionIdFromUri(String uri) {
        Validate.notNull(uri);
        int separatorIndex = uri.indexOf(59);
        if (separatorIndex != -1) {
            return uri.substring(0, separatorIndex);
        }
        return uri;
    }
}

