/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.nio.protocol;

import com.microsoft.applicationinsights.web.dependencies.http.ContentTooLongException;
import com.microsoft.applicationinsights.web.dependencies.http.HttpEntity;
import com.microsoft.applicationinsights.web.dependencies.http.HttpEntityEnclosingRequest;
import com.microsoft.applicationinsights.web.dependencies.http.HttpRequest;
import com.microsoft.applicationinsights.web.dependencies.http.entity.ContentType;
import com.microsoft.applicationinsights.web.dependencies.http.nio.ContentDecoder;
import com.microsoft.applicationinsights.web.dependencies.http.nio.IOControl;
import com.microsoft.applicationinsights.web.dependencies.http.nio.entity.ContentBufferEntity;
import com.microsoft.applicationinsights.web.dependencies.http.nio.protocol.AbstractAsyncRequestConsumer;
import com.microsoft.applicationinsights.web.dependencies.http.nio.util.HeapByteBufferAllocator;
import com.microsoft.applicationinsights.web.dependencies.http.nio.util.SimpleInputBuffer;
import com.microsoft.applicationinsights.web.dependencies.http.protocol.HttpContext;
import com.microsoft.applicationinsights.web.dependencies.http.util.Asserts;
import java.io.IOException;

public class BasicAsyncRequestConsumer
extends AbstractAsyncRequestConsumer<HttpRequest> {
    private volatile HttpRequest request;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onRequestReceived(HttpRequest request) throws IOException {
        this.request = request;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
        ((HttpEntityEnclosingRequest)this.request).setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.request = null;
        this.buf = null;
    }

    @Override
    protected HttpRequest buildResult(HttpContext context) {
        return this.request;
    }
}

