/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.impl.io;

import com.microsoft.applicationinsights.web.dependencies.http.HttpRequest;
import com.microsoft.applicationinsights.web.dependencies.http.HttpRequestFactory;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.web.dependencies.http.config.MessageConstraints;
import com.microsoft.applicationinsights.web.dependencies.http.impl.DefaultHttpRequestFactory;
import com.microsoft.applicationinsights.web.dependencies.http.impl.io.DefaultHttpRequestParser;
import com.microsoft.applicationinsights.web.dependencies.http.io.HttpMessageParser;
import com.microsoft.applicationinsights.web.dependencies.http.io.HttpMessageParserFactory;
import com.microsoft.applicationinsights.web.dependencies.http.io.SessionInputBuffer;
import com.microsoft.applicationinsights.web.dependencies.http.message.BasicLineParser;
import com.microsoft.applicationinsights.web.dependencies.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

