/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.AbstractUnixPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.UnixTotalMemInfoParser;
import com.microsoft.applicationinsights.telemetry.PerformanceCounterTelemetry;
import java.io.BufferedReader;
import java.io.FileReader;

final class UnixTotalMemoryPerformanceCounter
extends AbstractUnixPerformanceCounter {
    private static final String MEM_FILE = "/proc/meminfo";
    private static final double KB = 1024.0;

    public UnixTotalMemoryPerformanceCounter() {
        super(MEM_FILE);
    }

    @Override
    public String getId() {
        return "JSDK_TotalMemoryPerformanceCounter";
    }

    @Override
    public void report(TelemetryClient telemetryClient) {
        Double totalAvailableMemory = this.getTotalAvailableMemory();
        if (totalAvailableMemory == null) {
            return;
        }
        InternalLogger.INSTANCE.trace("Sending Performance Counter: %s %s: %s", "Memory", "Available Bytes", totalAvailableMemory);
        PerformanceCounterTelemetry telemetry = new PerformanceCounterTelemetry("Memory", "Available Bytes", "", totalAvailableMemory);
        telemetryClient.track(telemetry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Double getTotalAvailableMemory() {
        String line;
        BufferedReader bufferedReader = null;
        Double result = null;
        UnixTotalMemInfoParser reader = new UnixTotalMemInfoParser();
        bufferedReader = new BufferedReader(new FileReader(this.getProcessFile()));
        while (!reader.done() && (line = bufferedReader.readLine()) != null) {
            reader.process(line);
        }
        result = reader.getValue() * 1024.0;
        if (bufferedReader == null) return result;
        try {
            bufferedReader.close();
            return result;
        }
        catch (Exception e) {
            this.logPerfCounterErrorError("Error while closing file : '%s'", e.toString());
        }
        return result;
        catch (Exception e) {
            try {
                result = null;
                this.logPerfCounterErrorError("Error while parsing file: '%s'", e.toString());
                if (bufferedReader == null) return result;
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    this.logPerfCounterErrorError("Error while closing file : '%s'", e2.toString());
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
                return result;
            }
            catch (Exception e3) {
                this.logPerfCounterErrorError("Error while closing file : '%s'", e3.toString());
            }
            return result;
        }
    }
}

