/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Preconditions;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.extensibility.PerformanceCountersCollectionPlugin;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import com.microsoft.applicationinsights.internal.shutdown.Stoppable;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public enum PerformanceCounterContainer implements Stoppable
{
    INSTANCE;

    private static final long START_COLLECTING_DELAY_IN_MILLIS = 60000L;
    private static final long START_DEFAULT_MIN_DELAY_IN_MILLIS = 20000L;
    public static final long DEFAULT_COLLECTION_FREQUENCY_IN_SEC = 60L;
    private static final long MIN_COLLECTION_FREQUENCY_IN_SEC = 1L;
    private final ConcurrentMap<String, PerformanceCounter> performanceCounters = new ConcurrentHashMap<String, PerformanceCounter>();
    private volatile boolean initialized = false;
    private PerformanceCountersCollectionPlugin plugin;
    private long startCollectingDelayInMillis = 60000L;
    private long collectionFrequencyInMS = 60000L;
    private TelemetryClient telemetryClient;
    private ScheduledThreadPoolExecutor threads;

    public boolean register(PerformanceCounter performanceCounter) {
        Preconditions.checkNotNull(performanceCounter, "performanceCounter should be non null, non empty value");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(performanceCounter.getId()), "performanceCounter's id should be non null, non empty value");
        this.initialize();
        InternalLogger.INSTANCE.trace("Registering PC '%s'", performanceCounter.getId());
        PerformanceCounter prev = this.performanceCounters.putIfAbsent(performanceCounter.getId(), performanceCounter);
        if (prev != null) {
            InternalLogger.INSTANCE.trace("Failed to store performance counter '%s', since there is already one", performanceCounter.getId());
            return false;
        }
        return true;
    }

    public void unregister(PerformanceCounter performanceCounter) {
        this.unregister(performanceCounter.getId());
    }

    public void unregister(String id) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(id), "id should be non null, non empty value");
        InternalLogger.INSTANCE.trace("Un-registering PC '%s'", id);
        this.performanceCounters.remove(id);
    }

    public long getStartCollectingDelayInMillis() {
        return this.startCollectingDelayInMillis;
    }

    public long getCollectionFrequencyInSec() {
        return this.collectionFrequencyInMS / 1000L;
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        if (!this.initialized) {
            return;
        }
        ThreadPoolUtils.stop(this.threads, timeout, timeUnit);
        this.initialized = false;
    }

    public void setCollectionFrequencyInSec(long collectionFrequencyInSec) {
        if (collectionFrequencyInSec <= 1L) {
            String errorMessage = String.format("Collecting Interval: illegal value '%d'. The minimum value, '%d', is used instead.", collectionFrequencyInSec, 1L);
            InternalLogger.INSTANCE.error(errorMessage, new Object[0]);
            collectionFrequencyInSec = 1L;
        }
        this.collectionFrequencyInMS = collectionFrequencyInSec * 1000L;
    }

    void setStartCollectingDelayInMillis(long startCollectingDelayInMillis) {
        if (startCollectingDelayInMillis < 20000L) {
            InternalLogger.INSTANCE.error("Start Collecting Delay: illegal value '%d'. The minimum value, '%'d, is used instead.", startCollectingDelayInMillis, 20000L);
            startCollectingDelayInMillis = 20000L;
        }
        this.startCollectingDelayInMillis = startCollectingDelayInMillis;
    }

    void clear() {
        this.performanceCounters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (!this.initialized) {
            PerformanceCounterContainer performanceCounterContainer = INSTANCE;
            synchronized (performanceCounterContainer) {
                if (!this.initialized) {
                    this.createThreadToCollect();
                    this.scheduleWork();
                    this.initialized = true;
                }
            }
        }
    }

    private void scheduleWork() {
        this.threads.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (PerformanceCounterContainer.this.telemetryClient == null) {
                    PerformanceCounterContainer.this.telemetryClient = new TelemetryClient();
                }
                if (PerformanceCounterContainer.this.plugin != null) {
                    try {
                        PerformanceCounterContainer.this.plugin.preCollection();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        try {
                            InternalLogger.INSTANCE.error("Error in thread scheduled for PerformanceCounterContainer Exception : %s ", ExceptionUtils.getStackTrace(t));
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable td) {
                            // empty catch block
                        }
                    }
                }
                for (PerformanceCounter performanceCounter : PerformanceCounterContainer.this.performanceCounters.values()) {
                    try {
                        performanceCounter.report(PerformanceCounterContainer.this.telemetryClient);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        try {
                            InternalLogger.INSTANCE.error("Exception while reporting performance counter '%s':  Exception : '%s'", performanceCounter.getId(), ExceptionUtils.getStackTrace(t));
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                if (PerformanceCounterContainer.this.plugin != null) {
                    try {
                        PerformanceCounterContainer.this.plugin.postCollection();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        try {
                            InternalLogger.INSTANCE.error("Error while executing post collection, Exception : %s ", ExceptionUtils.getStackTrace(t));
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }, this.startCollectingDelayInMillis, this.collectionFrequencyInMS, TimeUnit.MILLISECONDS);
        SDKShutdownActivity.INSTANCE.register(INSTANCE);
    }

    private void createThreadToCollect() {
        this.threads = new ScheduledThreadPoolExecutor(1);
        this.threads.setThreadFactory(ThreadPoolUtils.createDaemonThreadFactory(PerformanceCounterContainer.class));
    }

    public void setPlugin(PerformanceCountersCollectionPlugin plugin) {
        this.plugin = plugin;
    }
}

