/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Optional;
import com.microsoft.applicationinsights.core.dependencies.google.gson.Gson;
import com.microsoft.applicationinsights.core.dependencies.google.gson.GsonBuilder;
import com.microsoft.applicationinsights.internal.channel.TransmissionHandler;
import com.microsoft.applicationinsights.internal.channel.TransmissionHandlerArgs;
import com.microsoft.applicationinsights.internal.channel.common.BackendResponse;
import com.microsoft.applicationinsights.internal.channel.common.GzipTelemetrySerializer;
import com.microsoft.applicationinsights.internal.channel.common.Transmission;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicyManager;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class PartialSuccessHandler
implements TransmissionHandler {
    public PartialSuccessHandler(TransmissionPolicyManager policy) {
    }

    @Override
    public void onTransmissionSent(TransmissionHandlerArgs args) {
        this.validateTransmissionAndSend(args);
    }

    boolean validateTransmissionAndSend(TransmissionHandlerArgs args) {
        if (args.getTransmission() != null && args.getTransmissionDispatcher() != null) {
            switch (args.getResponseCode()) {
                case 206: {
                    BackendResponse backendResponse = this.getBackendResponse(args.getResponseBody());
                    List<String> originalItems = this.generateOriginalItems(args);
                    if (backendResponse != null && originalItems.size() != backendResponse.itemsReceived) {
                        InternalLogger.INSTANCE.trace("Skipping partial content handler due to itemsReceived being larger than the items sent.", new Object[0]);
                        return false;
                    }
                    if (backendResponse != null && backendResponse.itemsAccepted < backendResponse.itemsReceived) {
                        ArrayList<String> newTransmission = new ArrayList<String>();
                        block6: for (BackendResponse.Error e : backendResponse.errors) {
                            switch (e.statusCode) {
                                case 408: 
                                case 429: 
                                case 439: 
                                case 500: 
                                case 503: {
                                    if (e.index >= originalItems.size()) continue block6;
                                    newTransmission.add(originalItems.get(e.index));
                                }
                            }
                        }
                        return this.sendNewTransmission(args, newTransmission);
                    }
                    InternalLogger.INSTANCE.trace("Skipping partial content handler due to itemsAccepted and itemsReceived being equal.", new Object[0]);
                    return false;
                }
            }
            InternalLogger.INSTANCE.trace("Http response code %s not handled by %s", args.getResponseCode(), this.getClass().getName());
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<String> generateOriginalItems(TransmissionHandlerArgs args) {
        ArrayList<String> originalItems = new ArrayList<String>();
        if ("gzip".equalsIgnoreCase(args.getTransmission().getWebContentEncodingType())) {
            BufferedReader bufferedReader;
            GZIPInputStream gis;
            block26: {
                String line;
                gis = null;
                bufferedReader = null;
                gis = new GZIPInputStream(new ByteArrayInputStream(args.getTransmission().getContent()));
                bufferedReader = new BufferedReader(new InputStreamReader(gis));
                while ((line = bufferedReader.readLine()) != null) {
                    originalItems.add(line);
                }
                if (gis == null) break block26;
                try {
                    gis.close();
                }
                catch (IOException ex) {
                    InternalLogger.INSTANCE.warn("Error while closing the GZIP stream.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(ex));
                }
            }
            if (bufferedReader == null) return originalItems;
            try {
                bufferedReader.close();
                return originalItems;
            }
            catch (IOException ex) {
                InternalLogger.INSTANCE.warn("Error while closing the buffered reader.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(ex));
            }
            return originalItems;
            catch (IOException ex) {
                block27: {
                    InternalLogger.INSTANCE.error("IOException: Error while reading the GZIP stream.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(ex));
                    if (gis == null) break block27;
                    try {
                        gis.close();
                    }
                    catch (IOException ex2) {
                        InternalLogger.INSTANCE.warn("Error while closing the GZIP stream.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(ex2));
                    }
                }
                if (bufferedReader == null) return originalItems;
                try {
                    bufferedReader.close();
                    return originalItems;
                }
                catch (IOException ex3) {
                    InternalLogger.INSTANCE.warn("Error while closing the buffered reader.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(ex3));
                }
                return originalItems;
            }
            catch (Throwable t) {
                block28: {
                    InternalLogger.INSTANCE.error("Error while reading the GZIP stream.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(t));
                    if (gis == null) break block28;
                    {
                        catch (Throwable throwable) {
                            if (gis != null) {
                                try {
                                    gis.close();
                                }
                                catch (IOException ex2) {
                                    InternalLogger.INSTANCE.warn("Error while closing the GZIP stream.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(ex2));
                                }
                            }
                            if (bufferedReader == null) throw throwable;
                            try {
                                bufferedReader.close();
                                throw throwable;
                            }
                            catch (IOException ex3) {
                                InternalLogger.INSTANCE.warn("Error while closing the buffered reader.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(ex3));
                            }
                            throw throwable;
                        }
                    }
                    try {
                        gis.close();
                    }
                    catch (IOException ex4) {
                        InternalLogger.INSTANCE.warn("Error while closing the GZIP stream.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(ex4));
                    }
                }
                if (bufferedReader == null) return originalItems;
                try {
                    bufferedReader.close();
                    return originalItems;
                }
                catch (IOException ex5) {
                    InternalLogger.INSTANCE.warn("Error while closing the buffered reader.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(ex5));
                }
                return originalItems;
            }
        }
        for (String s : new String(args.getTransmission().getContent()).split("\r\n")) {
            originalItems.add(s);
        }
        return originalItems;
    }

    boolean sendNewTransmission(TransmissionHandlerArgs args, List<String> newTransmission) {
        if (!newTransmission.isEmpty()) {
            GzipTelemetrySerializer serializer = new GzipTelemetrySerializer();
            Optional<Transmission> newT = serializer.serialize(newTransmission);
            args.getTransmissionDispatcher().dispatch(newT.get());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackendResponse getBackendResponse(String response) {
        BackendResponse backend = null;
        try {
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            backend = gson.fromJson(response, BackendResponse.class);
        }
        catch (Throwable t) {
            InternalLogger.INSTANCE.trace("Error deserializing backend response with Gson.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(t));
        }
        return backend;
    }
}

