/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.xstream.mapper;

import com.microsoft.applicationinsights.core.dependencies.xstream.mapper.Mapper;
import com.microsoft.applicationinsights.core.dependencies.xstream.mapper.MapperWrapper;
import com.microsoft.applicationinsights.core.dependencies.xstream.security.AnyTypePermission;
import com.microsoft.applicationinsights.core.dependencies.xstream.security.ForbiddenClassException;
import com.microsoft.applicationinsights.core.dependencies.xstream.security.NoTypePermission;
import com.microsoft.applicationinsights.core.dependencies.xstream.security.TypePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SecurityMapper
extends MapperWrapper {
    private final List permissions;

    public SecurityMapper(Mapper wrapped) {
        this(wrapped, null);
    }

    public SecurityMapper(Mapper wrapped, TypePermission[] permissions) {
        super(wrapped);
        this.permissions = permissions == null ? new ArrayList() : new ArrayList<TypePermission>(Arrays.asList(permissions));
    }

    public void addPermission(TypePermission permission) {
        if (permission.equals(NoTypePermission.NONE) || permission.equals(AnyTypePermission.ANY)) {
            this.permissions.clear();
        }
        this.permissions.add(0, permission);
    }

    public Class realClass(String elementName) {
        Class type = super.realClass(elementName);
        for (int i = 0; i < this.permissions.size(); ++i) {
            TypePermission permission = (TypePermission)this.permissions.get(i);
            if (!permission.allows(type)) continue;
            return type;
        }
        throw new ForbiddenClassException(type);
    }
}

