/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.ConnectionTestPath;
import com.mchange.v2.c3p0.impl.DefaultConnectionTester;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.ResourcePool;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.PooledConnection;

final class IsValidSimplifiedConnectionTestPath
implements ConnectionTestPath {
    private static final MLogger logger = MLog.getLogger(IsValidSimplifiedConnectionTestPath.class);
    private final ResourcePool rp;
    private final int isValidTimeout;

    IsValidSimplifiedConnectionTestPath(ResourcePool resourcePool, int n) {
        this.rp = resourcePool;
        if (n < 0) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Negative values of connectionIsValidTimeout are not supported. Using default value of " + C3P0Defaults.connectionIsValidTimeout());
            }
            this.isValidTimeout = C3P0Defaults.connectionIsValidTimeout();
        } else {
            this.isValidTimeout = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testPooledConnection(PooledConnection pooledConnection, Connection connection) throws Exception {
        if (connection != null) {
            this.doTestConnection(connection);
        } else {
            Connection connection2 = null;
            try {
                connection2 = pooledConnection.getConnection();
                this.doTestConnection(connection2);
            }
            finally {
                ConnectionUtils.attemptClose((Connection)connection2);
            }
        }
    }

    private void doTestConnection(Connection connection) throws Exception {
        try {
            if (!connection.isValid(this.isValidTimeout)) {
                throw new SQLException("Connection is invalid. (isValid returned false).");
            }
        }
        catch (SQLException sQLException) {
            if (DefaultConnectionTester.probableInvalidDb(sQLException)) {
                this.rp.resetPool();
            }
            throw sQLException;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "An unexpected Exception occurred while testing a Connection.", (Throwable)exception);
            }
            throw exception;
        }
    }

    public static int isValidTestConnectionForStatusOnly(Connection connection, int n) {
        try {
            if (connection.isValid(n)) {
                return 0;
            }
            return -1;
        }
        catch (SQLException sQLException) {
            if (DefaultConnectionTester.probableInvalidDb(sQLException)) {
                return -8;
            }
            return -1;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "An unexpected Exception occurred while testing a Connection.", (Throwable)exception);
            }
            return -1;
        }
    }
}

