/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiTestAbstract;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.ClientImpl;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupImpl;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.RootThesaurusImpl;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.SessionImpl;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.UserImpl;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageServiceTest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyExtension;

public class VradiDataServiceTest
extends VradiTestAbstract {
    private static final Log log = LogFactory.getLog(VradiStorageServiceTest.class);

    protected String[] initClientDatas() {
        ClientImpl client = new ClientImpl();
        client.setName("newClient");
        UserImpl user = new UserImpl();
        user.setName("newUser");
        user.setClient(client.getWikittyId());
        GroupImpl group = new GroupImpl();
        group.setName("newGroup");
        group.addUser(user.getWikittyId());
        client = (Client)this.wikittyProxy.store((BusinessEntity)client);
        user = (User)this.wikittyProxy.store((BusinessEntity)user);
        group = (Group)this.wikittyProxy.store((BusinessEntity)group);
        return new String[]{client.getWikittyId(), user.getWikittyId(), group.getWikittyId()};
    }

    @Test
    public void testPropositions() throws Exception {
        RootThesaurusImpl rootThesaurus = new RootThesaurusImpl();
        rootThesaurus.setName("thesaurus");
        this.wikittyProxy.store((BusinessEntity)rootThesaurus);
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        FormPagedResult fpNogent = this.testSearch("Nogent");
        String fIdNogent = (String)fpNogent.getFormsIdsToShow().get(0);
        Assert.assertNotNull((Object)fIdNogent);
        List list = this.dataService.proposeThesaurus(fIdNogent);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)list.size(), (long)0L);
        Thesaurus nogent = this.createThesaurus("Nogent", (RootThesaurus)rootThesaurus, "Nogent");
        list = this.dataService.proposeThesaurus(fIdNogent);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)list.size(), (long)1L);
        Assert.assertNotNull(list.get(0));
        Assert.assertEquals((Object)((Thesaurus)list.get(0)).getWikittyId(), (Object)nogent.getWikittyId());
        nogent.addAttachment(fIdNogent);
        this.wikittyProxy.store((BusinessEntity)nogent);
        list = this.dataService.proposeThesaurus(fIdNogent);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)list.size(), (long)0L);
    }

    @Test
    public void testPropositions2() throws Exception {
        RootThesaurusImpl rootThesaurus = new RootThesaurusImpl();
        rootThesaurus.setName("thesaurus");
        this.wikittyProxy.store((BusinessEntity)rootThesaurus);
        WikittyExtension extension = this.createFileFormType();
        this.initData(extension);
        Thesaurus tagSoiree = this.createThesaurus("abc", (RootThesaurus)rootThesaurus, "soir\u00e9e");
        Thesaurus tagFrites = this.createThesaurus("def", (RootThesaurus)rootThesaurus, "frites");
        String formIdSoiree = (String)this.testSearch("description:soir\u00e9e").getFormsIdsToShow().get(0);
        List nodes = this.dataService.proposeThesaurus(formIdSoiree);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)1L);
        String node1 = ((Thesaurus)nodes.get(0)).getWikittyId();
        Assert.assertEquals((Object)node1, (Object)tagSoiree.getWikittyId());
        String formIdFrites = (String)this.testSearch("description:frites").getFormsIdsToShow().get(0);
        nodes = this.dataService.proposeThesaurus(formIdFrites);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)1L);
        node1 = ((Thesaurus)nodes.get(0)).getWikittyId();
        Assert.assertEquals((Object)node1, (Object)tagFrites.getWikittyId());
        Thesaurus tagSoireeFrites = this.createThesaurus("ghi", (RootThesaurus)rootThesaurus, "soir\u00e9e", "frites");
        nodes = this.dataService.proposeThesaurus(formIdSoiree);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)2L);
        node1 = ((Thesaurus)nodes.get(0)).getWikittyId();
        String node2 = ((Thesaurus)nodes.get(1)).getWikittyId();
        Assert.assertTrue((node1.equals(tagSoiree.getWikittyId()) || node1.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        Assert.assertTrue((node2.equals(tagSoiree.getWikittyId()) || node2.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        nodes = this.dataService.proposeThesaurus(formIdFrites);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)2L);
        node1 = ((Thesaurus)nodes.get(0)).getWikittyId();
        node2 = ((Thesaurus)nodes.get(1)).getWikittyId();
        Assert.assertTrue((node1.equals(tagFrites.getWikittyId()) || node1.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        Assert.assertTrue((node2.equals(tagFrites.getWikittyId()) || node2.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        Thesaurus tagSoeur = this.createThesaurus("jkl", (RootThesaurus)rootThesaurus, "soeur");
        nodes = this.dataService.proposeThesaurus(formIdSoiree);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)2L);
        node1 = ((Thesaurus)nodes.get(0)).getWikittyId();
        node2 = ((Thesaurus)nodes.get(1)).getWikittyId();
        Assert.assertTrue((node1.equals(tagSoiree.getWikittyId()) || node1.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        Assert.assertTrue((node2.equals(tagSoiree.getWikittyId()) || node2.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        nodes = this.dataService.proposeThesaurus(formIdFrites);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)3L);
        node1 = ((Thesaurus)nodes.get(0)).getWikittyId();
        node2 = ((Thesaurus)nodes.get(1)).getWikittyId();
        String node3 = ((Thesaurus)nodes.get(2)).getWikittyId();
        Assert.assertTrue((node1.equals(tagFrites.getWikittyId()) || node1.equals(tagSoireeFrites.getWikittyId()) || node1.equals(tagSoeur.getWikittyId()) ? 1 : 0) != 0);
        Assert.assertTrue((node2.equals(tagFrites.getWikittyId()) || node2.equals(tagSoireeFrites.getWikittyId()) || node2.equals(tagSoeur.getWikittyId()) ? 1 : 0) != 0);
        Assert.assertTrue((node3.equals(tagFrites.getWikittyId()) || node3.equals(tagSoireeFrites.getWikittyId()) || node3.equals(tagSoeur.getWikittyId()) ? 1 : 0) != 0);
    }

    @Test
    public void testGetSessionForDay() throws Exception {
        Date date = new Date();
        ArrayList<SessionImpl> sessions = new ArrayList<SessionImpl>();
        SessionImpl session = new SessionImpl();
        session.setSessionDate(date);
        session.setNum(0);
        session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session);
        SessionImpl session2 = new SessionImpl();
        session2.setSessionDate(date);
        session2.setNum(1);
        session2.setStatus(VradiConstants.SessionStatus.ERROR.getValue());
        sessions.add(session2);
        SessionImpl session3 = new SessionImpl();
        session3.setSessionDate(date);
        session3.setNum(2);
        session3.setStatus(VradiConstants.SessionStatus.SENT.getValue());
        sessions.add(session3);
        this.wikittyProxy.store(sessions);
        List sessionList = this.dataService.getSessions(date);
        Assert.assertEquals((long)3L, (long)sessionList.size());
        List sessionList2 = this.dataService.getSessions(DateUtils.addDays((Date)date, (int)1));
        Assert.assertEquals((long)0L, (long)sessionList2.size());
        SessionImpl session4 = new SessionImpl();
        session4.setSessionDate(DateUtils.addSeconds((Date)date, (int)1));
        session4.setNum(3);
        session4.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        this.wikittyProxy.store((BusinessEntity)session4);
        List sessionList3 = this.dataService.getSessions(DateUtils.addDays((Date)date, (int)1));
        Assert.assertEquals((long)0L, (long)sessionList3.size());
    }

    @Test
    public void testGetLastCloseSession() throws Exception {
        Date date = new Date();
        ArrayList<SessionImpl> sessions = new ArrayList<SessionImpl>();
        SessionImpl session = new SessionImpl();
        session.setSessionDate(date);
        session.setNum(3);
        session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session);
        SessionImpl session2 = new SessionImpl();
        session2.setSessionDate(DateUtils.addMinutes((Date)date, (int)-1));
        session2.setNum(2);
        session2.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session2);
        SessionImpl session3 = new SessionImpl();
        session3.setSessionDate(DateUtils.addMinutes((Date)date, (int)-2));
        session3.setNum(10);
        session3.setStatus(VradiConstants.SessionStatus.SENT.getValue());
        sessions.add(session3);
        SessionImpl session4 = new SessionImpl();
        session4.setSessionDate(DateUtils.addDays((Date)date, (int)-1));
        session4.setNum(1);
        session4.setStatus(VradiConstants.SessionStatus.SENT.getValue());
        sessions.add(session4);
        SessionImpl session5 = new SessionImpl();
        session5.setSessionDate(DateUtils.addDays((Date)date, (int)-2));
        session5.setNum(1);
        session5.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session5);
        this.wikittyProxy.store(sessions);
        Session result = this.dataService.getLastCloseSession();
        Assert.assertEquals((long)10L, (long)result.getNum());
    }

    @Test
    public void testGetLastOpenedSession() throws Exception {
        Date date = new Date();
        ArrayList<SessionImpl> sessions = new ArrayList<SessionImpl>();
        SessionImpl session = new SessionImpl();
        session.setSessionDate(date);
        session.setNum(3);
        session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session);
        SessionImpl session2 = new SessionImpl();
        session2.setSessionDate(DateUtils.addMinutes((Date)date, (int)-1));
        session2.setNum(2);
        session2.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session2);
        SessionImpl session3 = new SessionImpl();
        session3.setSessionDate(DateUtils.addMinutes((Date)date, (int)-2));
        session3.setNum(1);
        session3.setStatus(VradiConstants.SessionStatus.ERROR.getValue());
        sessions.add(session3);
        SessionImpl session4 = new SessionImpl();
        session4.setSessionDate(DateUtils.addDays((Date)date, (int)-1));
        session4.setNum(1);
        session4.setStatus(VradiConstants.SessionStatus.SENT.getValue());
        sessions.add(session4);
        SessionImpl session5 = new SessionImpl();
        session5.setSessionDate(DateUtils.addDays((Date)date, (int)-2));
        session5.setNum(1);
        session5.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session5);
        this.wikittyProxy.store(sessions);
        Session result = this.dataService.getLastOpenSession();
        Assert.assertEquals((long)3L, (long)result.getNum());
    }

    @Test
    public void testGetLastOpenedSessionAllClosed() throws Exception {
        Date date = new Date();
        ArrayList<SessionImpl> sessions = new ArrayList<SessionImpl>();
        SessionImpl session = new SessionImpl();
        session.setSessionDate(DateUtils.addMinutes((Date)date, (int)-2));
        session.setNum(1);
        session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session);
        SessionImpl session2 = new SessionImpl();
        session2.setSessionDate(DateUtils.addMinutes((Date)date, (int)-1));
        session2.setNum(2);
        session2.setStatus(VradiConstants.SessionStatus.SENT.getValue());
        sessions.add(session2);
        SessionImpl session3 = new SessionImpl();
        session3.setSessionDate(date);
        session3.setNum(3);
        session3.setStatus(VradiConstants.SessionStatus.SENT.getValue());
        sessions.add(session3);
        this.wikittyProxy.store(sessions);
        Session result = this.dataService.getLastOpenSession();
        Assert.assertNull((Object)result);
    }

    public void testDeleteClient() throws Exception {
        String[] ids = this.initClientDatas();
        this.dataService.deleteClient(ids[0]);
        Client client = (Client)this.wikittyProxy.restore(Client.class, ids[0]);
        Assert.assertNull((Object)client);
        User user = (User)this.wikittyProxy.restore(User.class, ids[1]);
        Assert.assertNull((Object)user);
        Group group = (Group)this.wikittyProxy.restore(Group.class, ids[2]);
        Assert.assertNull((Object)group.getUser());
    }

    public void testDeleteUser() throws VradiException {
        String[] ids = this.initClientDatas();
        this.dataService.deleteUser(ids[1]);
        User user = (User)this.wikittyProxy.restore(User.class, ids[1]);
        Assert.assertNull((Object)user);
        Group group = (Group)this.wikittyProxy.restore(Group.class, ids[2]);
        Assert.assertNull((Object)group.getUser());
    }

    public void testDeleteGroup() throws VradiException {
        String[] ids = this.initClientDatas();
        this.dataService.deleteUser(ids[2]);
        Group group = (Group)this.wikittyProxy.restore(Group.class, ids[2]);
        Assert.assertNull((Object)group);
    }
}

