/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: UnsupportedQueryException.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-services/src/main/java/com/jurismarches/vradi/services/search/UnsupportedQueryException.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.services.search;

import static org.nuiton.i18n.I18n._;

import org.apache.lucene.search.Query;

/**
 * <code>UnsupportedQueryException</code> indicates that a <code>Query</code>
 *  is not supported by the <code>LuceneQueryParser</code>.
 * 
 * @author $Author: tchemit $
 * @version $Revision: 1715 $ $Date: 2010-10-27 21:21:28 +0200 (mer., 27 oct. 2010) $
 * @since 0.0.4
 */
public class UnsupportedQueryException extends Exception {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** Query that throw the exception. */
    protected String query = null;
    
    public UnsupportedQueryException(String query, Throwable cause) {
        super(_("Unsupported query: %s", query), cause);
        this.query = query;
    }
    
    public UnsupportedQueryException(Query query) {
        super("unsupported query: " + query.toString());
    }
    
    public String getQuery() {
        return query;
    }
}
