/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.webharvest.definition.IncludeDef;
import org.webharvest.definition.ScraperConfiguration;
import org.webharvest.exception.FileException;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class IncludeProcessor
extends BaseProcessor {
    private IncludeDef includeDef;

    public IncludeProcessor(IncludeDef includeDef) {
        super(includeDef);
        this.includeDef = includeDef;
    }

    @Override
    public Variable execute(Scraper scraper, ScraperContext context) {
        boolean isUrl = false;
        String path = BaseTemplater.execute(this.includeDef.getPath(), scraper.getScriptEngine());
        this.setProperty("Path", path);
        String fullPath = path = CommonUtil.adaptFilename(path);
        ScraperConfiguration configuration = scraper.getConfiguration();
        File originalFile = configuration.getSourceFile();
        String originalUrl = configuration.getUrl();
        if (originalFile != null) {
            String originalPath = CommonUtil.adaptFilename(originalFile.getAbsolutePath());
            int index = originalPath.lastIndexOf(47);
            if (index > 0) {
                String workingPath = originalPath.substring(0, index);
                fullPath = CommonUtil.getAbsoluteFilename(workingPath, path);
            }
        } else if (originalUrl != null) {
            fullPath = CommonUtil.fullUrl(originalUrl, path);
            isUrl = true;
        }
        try {
            ScraperConfiguration includedConfig = isUrl ? new ScraperConfiguration(new URL(fullPath)) : new ScraperConfiguration(fullPath);
            scraper.execute(includedConfig.getOperations());
            return new EmptyVariable();
        }
        catch (FileNotFoundException e) {
            throw new FileException("Cannot include configuration file " + fullPath, e);
        }
        catch (MalformedURLException e) {
            throw new FileException("Cannot include configuration file " + fullPath, e);
        }
        catch (IOException e) {
            throw new FileException("Cannot include configuration file " + fullPath, e);
        }
    }
}

