/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XmlSerializer;

public class PrettyXmlSerializer
extends XmlSerializer {
    private static final String INDENTATION_STRING = "\t";

    public PrettyXmlSerializer(CleanerProperties props) {
        super(props);
    }

    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        this.serializePrettyXml(tagNode, writer, 0);
    }

    private String indent(int level) {
        String result = "";
        while (level > 0) {
            result = result + INDENTATION_STRING;
            --level;
        }
        return result;
    }

    private String getIndentedText(String content, int level) {
        String indent = this.indent(level);
        StringBuffer result = new StringBuffer(content.length());
        StringTokenizer tokenizer = new StringTokenizer(content, "\n\r");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            if ("".equals(line)) continue;
            result.append(indent + line + "\n");
        }
        return result.toString();
    }

    private String getSingleLineOfChildren(List children) {
        StringBuffer result = new StringBuffer();
        Iterator childrenIt = children.iterator();
        boolean isFirst = true;
        while (childrenIt.hasNext()) {
            Object child = childrenIt.next();
            if (!(child instanceof ContentToken)) {
                return null;
            }
            ContentToken contentToken = (ContentToken)child;
            String content = contentToken.getContent();
            if (isFirst) {
                content = Utils.ltrim(content);
            }
            if (!childrenIt.hasNext()) {
                content = Utils.rtrim(content);
            }
            if (content.indexOf("\n") >= 0 || content.indexOf("\r") >= 0) {
                return null;
            }
            result.append(content);
            isFirst = false;
        }
        return result.toString();
    }

    protected void serializePrettyXml(TagNode tagNode, Writer writer, int level) throws IOException {
        List tagChildren = tagNode.getChildren();
        String indent = this.indent(level);
        writer.write(indent);
        this.serializeOpenTag(tagNode, writer);
        if (!this.isMinimizedTagSyntax(tagNode)) {
            String singleLine = this.getSingleLineOfChildren(tagChildren);
            boolean dontEscape = this.dontEscape(tagNode);
            if (singleLine != null) {
                if (!this.dontEscape(tagNode)) {
                    writer.write(this.escapeXml(singleLine));
                } else {
                    writer.write(singleLine.replaceAll("]]>", "]]&gt;"));
                }
            } else {
                writer.write("\n");
                Iterator childrenIt = tagChildren.iterator();
                while (childrenIt.hasNext()) {
                    String content;
                    Object child = childrenIt.next();
                    if (child instanceof TagNode) {
                        this.serializePrettyXml((TagNode)child, writer, level + 1);
                        continue;
                    }
                    if (child instanceof ContentToken) {
                        ContentToken contentToken = (ContentToken)child;
                        content = dontEscape ? contentToken.getContent().replaceAll("]]>", "]]&gt;") : this.escapeXml(contentToken.getContent());
                        writer.write(this.getIndentedText(content, level + 1));
                        continue;
                    }
                    if (!(child instanceof CommentToken)) continue;
                    CommentToken commentToken = (CommentToken)child;
                    content = commentToken.getCommentedContent();
                    writer.write(this.getIndentedText(content, level + 1));
                }
            }
            if (singleLine == null) {
                writer.write(indent);
            }
            this.serializeEndTag(tagNode, writer);
        }
    }
}

