/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.variables.ListVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class TokenizePlugin
extends WebHarvestPlugin {
    @Override
    public String getName() {
        return "tokenize";
    }

    @Override
    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        String delimiters = this.evaluateAttribute("delimiters", scraper);
        if (delimiters == null || "".equals(delimiters)) {
            delimiters = "\n\r";
        }
        boolean trimTokens = this.evaluateAttributeAsBoolean("trimtokens", true, scraper);
        boolean allowWmptyTokens = this.evaluateAttributeAsBoolean("allowemptytokens", false, scraper);
        String text = this.executeBody(scraper, context).toString();
        this.setProperty("Delimiters", delimiters);
        this.setProperty("Trim tokens", trimTokens);
        this.setProperty("Allow empty tokens", allowWmptyTokens);
        String[] tokens = CommonUtil.tokenize(text, delimiters, trimTokens, allowWmptyTokens);
        ListVariable listVariable = new ListVariable();
        for (String token : tokens) {
            listVariable.addVariable(new NodeVariable(token));
        }
        return listVariable;
    }

    @Override
    public String[] getValidAttributes() {
        return new String[]{"delimiters", "trimtokens", "allowemptytokens"};
    }

    @Override
    public String[] getAttributeValueSuggestions(String attributeName) {
        if ("trimtokens".equalsIgnoreCase(attributeName)) {
            return new String[]{"true", "false"};
        }
        if ("allowemptytokens".equalsIgnoreCase(attributeName)) {
            return new String[]{"true", "false"};
        }
        return null;
    }
}

