/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import org.webharvest.definition.ScriptDef;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class ScriptProcessor
extends BaseProcessor {
    public static final String CONTEXT_VARIABLE_NAME = "context";
    private ScriptDef scriptDef;

    public ScriptProcessor(ScriptDef scriptDef) {
        super(scriptDef);
        this.scriptDef = scriptDef;
    }

    @Override
    public Variable execute(Scraper scraper, ScraperContext context) {
        Variable scriptText = this.getBodyTextContent(this.scriptDef, scraper, context);
        String language = BaseTemplater.execute(this.scriptDef.getLanguage(), scraper.getScriptEngine());
        if (language != null) {
            language = language.toLowerCase();
        }
        String returnExpression = this.scriptDef.getReturnExpression();
        ScriptEngine scriptEngine = language == null ? scraper.getScriptEngine() : scraper.getScriptEngine(language);
        scriptEngine.eval(scriptText.toString());
        if (returnExpression != null) {
            String returnExpressionEvaluated = BaseTemplater.execute(this.scriptDef.getReturnExpression(), scraper.getScriptEngine());
            Object returnValue = scriptEngine.eval(returnExpressionEvaluated);
            return CommonUtil.createVariable(returnValue);
        }
        return new EmptyVariable();
    }
}

