/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webharvest.definition.HttpDef;
import org.webharvest.exception.HttpException;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.BodyProcessor;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.runtime.web.HttpClientManager;
import org.webharvest.runtime.web.HttpParamInfo;
import org.webharvest.runtime.web.HttpResponseWrapper;
import org.webharvest.utils.CommonUtil;
import org.webharvest.utils.KeyValuePair;

public class HttpProcessor
extends BaseProcessor {
    private static final String HTML_META_CHARSET_REGEX = "(<meta\\s*http-equiv\\s*=\\s*(\"|')content-type(\"|')\\s*content\\s*=\\s*(\"|')text/html;\\s*charset\\s*=\\s*(.*?)(\"|')/?>)";
    private HttpDef httpDef;
    private Map<String, HttpParamInfo> httpParams = new LinkedHashMap<String, HttpParamInfo>();
    private Map httpHeaderMap = new HashMap();

    public HttpProcessor(HttpDef httpDef) {
        super(httpDef);
        this.httpDef = httpDef;
    }

    @Override
    public Variable execute(Scraper scraper, ScraperContext context) {
        NodeVariable result;
        scraper.setRunningHttpProcessor(this);
        ScriptEngine scriptEngine = scraper.getScriptEngine();
        String url = BaseTemplater.execute(this.httpDef.getUrl(), scriptEngine);
        String method = BaseTemplater.execute(this.httpDef.getMethod(), scriptEngine);
        String multipart = BaseTemplater.execute(this.httpDef.getMultipart(), scriptEngine);
        boolean isMultipart = CommonUtil.getBooleanValue(multipart, false);
        String specifiedCharset = BaseTemplater.execute(this.httpDef.getCharset(), scriptEngine);
        String username = BaseTemplater.execute(this.httpDef.getUsername(), scriptEngine);
        String password = BaseTemplater.execute(this.httpDef.getPassword(), scriptEngine);
        String cookiePolicy = BaseTemplater.execute(this.httpDef.getCookiePolicy(), scriptEngine);
        String charset = specifiedCharset;
        if (charset == null) {
            charset = scraper.getConfiguration().getCharset();
        }
        new BodyProcessor(this.httpDef).execute(scraper, context);
        HttpClientManager manager = scraper.getHttpClientManager();
        manager.setCookiePolicy(cookiePolicy);
        HttpResponseWrapper res = manager.execute(method, isMultipart, url, charset, username, password, this.httpParams, this.httpHeaderMap);
        scraper.removeRunningHttpProcessor();
        String mimeType = res.getMimeType();
        long contentLength = res.getContentLength();
        if (scraper.getLogger().isInfoEnabled()) {
            scraper.getLogger().info((Object)("Downloaded: " + url + ", mime type = " + mimeType + ", length = " + contentLength + "B."));
        }
        String responseCharset = res.getCharset();
        byte[] responseBody = res.getBody();
        if (mimeType == null || mimeType.indexOf("text") >= 0 || mimeType.indexOf("xml") >= 0 || mimeType.indexOf("javascript") >= 0) {
            String text = "";
            try {
                if (specifiedCharset == null) {
                    if (responseCharset != null && Charset.isSupported(responseCharset)) {
                        charset = responseCharset;
                    }
                    if ("text/html".equalsIgnoreCase(res.getMimeType())) {
                        String firstBodyKb = new String(responseBody, 0, Math.min(responseBody.length, 1024), "ASCII");
                        Matcher matcher = Pattern.compile(HTML_META_CHARSET_REGEX, 2).matcher(firstBodyKb);
                        if (matcher.find()) {
                            String foundCharset = matcher.group(5);
                            try {
                                if (Charset.isSupported(foundCharset)) {
                                    charset = foundCharset;
                                }
                            }
                            catch (IllegalCharsetNameException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                text = new String(responseBody, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new HttpException("Charset " + charset + " is not supported!", e);
            }
            result = new NodeVariable(text);
        } else {
            result = new NodeVariable(responseBody);
        }
        this.setProperty("URL", url);
        this.setProperty("Method", method);
        this.setProperty("Multipart", String.valueOf(isMultipart));
        this.setProperty("Charset", charset);
        this.setProperty("Content length", String.valueOf(contentLength));
        this.setProperty("Status code", res.getStatusCode());
        this.setProperty("Status text", res.getStatusText());
        KeyValuePair<String>[] headerPairs = res.getHeaders();
        if (headerPairs != null) {
            int index = 1;
            for (KeyValuePair<String> pair : headerPairs) {
                this.setProperty("HTTP header [" + index + "]: " + pair.getKey(), pair.getValue());
                ++index;
            }
        }
        return result;
    }

    protected void addHttpParam(String name, boolean isFile, String fileName, String contentType, Variable value) {
        HttpParamInfo httpParamInfo = new HttpParamInfo(name, isFile, fileName, contentType, value);
        this.httpParams.put(name, httpParamInfo);
    }

    protected void addHttpHeader(String name, String value) {
        this.httpHeaderMap.put(name, value);
    }
}

