/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.webharvest.gui.component.CommonDialog;
import org.webharvest.gui.component.WHCheckBox;
import org.webharvest.gui.component.WHComboBox;
import org.webharvest.gui.component.WHRadioButton;

public class FindReplaceDialog
extends CommonDialog {
    private static final int OPERATION_FIND = 1;
    private static final int OPERATION_REPLACE = 2;
    private int operation = 1;
    private Frame parentFrame;
    private JComboBox searchComboBox;
    private JLabel replaceLabel;
    private JComboBox replaceComboBox;
    private JTextComponent textComponent;
    private JCheckBox caseSensitiveCheckBox;
    private JCheckBox regularExpressionsCheckBox;
    private JRadioButton forwardRadioButton;
    private JRadioButton backwordRadioButton;
    private JRadioButton entireScopeRadioButton;

    public FindReplaceDialog(Frame parentFrame) throws HeadlessException {
        super("Find Text");
        this.parentFrame = parentFrame;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                FindReplaceDialog.this.searchComboBox.requestFocus();
                FindReplaceDialog.this.searchComboBox.getEditor().selectAll();
            }
        });
        this.createGui();
    }

    private void createGui() {
        Container contentPane = this.getContentPane();
        JPanel topPanel = new JPanel(new GridBagLayout());
        contentPane.setLayout(new BorderLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.insets = new Insets(2, 5, 2, 5);
        this.searchComboBox = new WHComboBox(new Object[0]){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(300, 20);
            }
        };
        this.searchComboBox.setEditable(true);
        this.searchComboBox.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplaceDialog.this.searchComboBox.setSelectedItem(e.getActionCommand());
            }
        });
        this.replaceLabel = new JLabel("Replace with: ");
        this.replaceComboBox = new WHComboBox(new Object[0]){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(300, 20);
            }
        };
        this.replaceComboBox.setEditable(true);
        this.replaceComboBox.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplaceDialog.this.replaceComboBox.setSelectedItem(e.getActionCommand());
            }
        });
        this.caseSensitiveCheckBox = new WHCheckBox("Case sensitive", false);
        constraints.gridx = 0;
        constraints.gridy = 0;
        topPanel.add((Component)new JLabel("Text to find: "), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        topPanel.add((Component)this.searchComboBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        topPanel.add((Component)this.replaceLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        topPanel.add((Component)this.replaceComboBox, constraints);
        JPanel optionsPanel = this.createOptionsPanel();
        JPanel directionsPanel = this.createDirectionsPanel();
        JPanel middlePanel = new JPanel(new GridLayout(1, 2));
        middlePanel.add(optionsPanel);
        middlePanel.add(directionsPanel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(new Insets(4, 4, 4, 4)));
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)middlePanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton okButton = this.createOkButton();
        okButton.setText("Find");
        buttonPanel.add(okButton);
        buttonPanel.add(this.createCancelButton());
        mainPanel.add((Component)buttonPanel, "South");
        contentPane.add((Component)mainPanel, "Center");
        this.pack();
    }

    private JPanel createDirectionsPanel() {
        JPanel directionsPanel = new JPanel(new GridLayout(3, 1));
        directionsPanel.setBorder(new TitledBorder("Direction"));
        ButtonGroup group = new ButtonGroup();
        this.forwardRadioButton = new WHRadioButton("Forward");
        this.forwardRadioButton.setSelected(true);
        this.backwordRadioButton = new WHRadioButton("Backword");
        this.entireScopeRadioButton = new WHRadioButton("Entire scope");
        group.add(this.forwardRadioButton);
        group.add(this.backwordRadioButton);
        group.add(this.entireScopeRadioButton);
        directionsPanel.add(this.forwardRadioButton);
        directionsPanel.add(this.backwordRadioButton);
        directionsPanel.add(this.entireScopeRadioButton);
        return directionsPanel;
    }

    private JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new GridLayout(3, 1));
        optionsPanel.setBorder(new TitledBorder("Options"));
        this.caseSensitiveCheckBox = new WHCheckBox("Case sensitive");
        optionsPanel.add(this.caseSensitiveCheckBox);
        this.regularExpressionsCheckBox = new WHCheckBox("Regular expressions");
        optionsPanel.add(this.regularExpressionsCheckBox);
        return optionsPanel;
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplaceDialog.this.setVisible(false);
            }
        };
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        stroke = KeyStroke.getKeyStroke(10, 0);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FindReplaceDialog.this.operation == 1) {
                    FindReplaceDialog.this.find(false);
                } else {
                    FindReplaceDialog.this.replace(false);
                }
            }
        };
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    public void open(JTextComponent textComponent, boolean isReplace) {
        this.setTextComponent(textComponent);
        this.operation = isReplace ? 2 : 1;
        this.replaceLabel.setVisible(isReplace);
        this.replaceComboBox.setVisible(isReplace);
        this.setTitle(isReplace ? "Replace Text" : "Find Text");
        this.pack();
        this.setLocationRelativeTo(this.parentFrame);
        this.setVisible(true);
    }

    public boolean find(boolean backward) {
        return this.find(backward, true);
    }

    public boolean find(boolean backward, boolean showMessageIfNotFound) {
        String searchText = this.searchComboBox.getEditor().getItem().toString();
        if (searchText == null) {
            return false;
        }
        if (this.textComponent == null || "".equals(searchText)) {
            return false;
        }
        if (this.isVisible()) {
            this.searchComboBox.removeItem(searchText);
            this.searchComboBox.insertItemAt(searchText, 0);
            this.searchComboBox.setSelectedItem(searchText);
        }
        if (this.isVisible()) {
            backward = this.backwordRadioButton.isSelected();
        }
        int startPosition = this.textComponent.getCaretPosition();
        Document doc = this.textComponent.getDocument();
        int len = doc.getLength();
        String content = "";
        try {
            if (backward) {
                content = doc.getText(0, startPosition > 1 ? startPosition - 1 : 0);
                startPosition = 0;
            } else if (this.isVisible() && this.entireScopeRadioButton.isSelected()) {
                content = doc.getText(0, len);
                startPosition = 0;
            } else {
                content = doc.getText(startPosition, len - startPosition);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return false;
        }
        this.setVisible(false);
        boolean isRegexp = this.regularExpressionsCheckBox.isSelected();
        boolean isCaseSensitive = this.caseSensitiveCheckBox.isSelected();
        if (!isCaseSensitive && !isRegexp) {
            content = content.toLowerCase();
            searchText = searchText.toLowerCase();
        }
        int index = -1;
        int foundLen = 0;
        if (isRegexp) {
            int flags = 32;
            if (!isCaseSensitive) {
                flags |= 2;
            }
            Pattern pattern = Pattern.compile(searchText, flags);
            Matcher matcher = pattern.matcher(content);
            if (!backward) {
                if (matcher.find()) {
                    index = matcher.start();
                    foundLen = matcher.end() - index;
                }
            } else {
                while (matcher.find()) {
                    index = matcher.start();
                    foundLen = matcher.end() - index;
                }
            }
        } else {
            index = backward ? content.lastIndexOf(searchText) : content.indexOf(searchText);
            foundLen = searchText.length();
        }
        if (index >= 0) {
            this.textComponent.requestFocusInWindow();
            this.textComponent.select(startPosition + index, startPosition + index + foundLen);
            return true;
        }
        if (showMessageIfNotFound) {
            Component top = this.findTopComponent();
            JOptionPane.showMessageDialog(top, "Next occurrence of \"" + searchText + "\" not found.", "Information", 1);
        }
        return false;
    }

    private Component findTopComponent() {
        Container top = this.textComponent;
        while (top.getParent() != null) {
            top = top.getParent();
        }
        return top;
    }

    public void replace(boolean backward) {
        boolean found;
        String searchText = (String)this.searchComboBox.getSelectedItem();
        String replaceText = (String)this.replaceComboBox.getSelectedItem();
        if (this.isVisible()) {
            if (!"".equals(searchText)) {
                this.searchComboBox.removeItem(searchText);
                this.searchComboBox.insertItemAt(searchText, 0);
                this.searchComboBox.setSelectedItem(searchText);
            }
            this.replaceComboBox.removeItem(replaceText);
            this.replaceComboBox.insertItemAt(replaceText, 0);
            this.replaceComboBox.setSelectedItem(replaceText);
        }
        if (this.textComponent == null || "".equals(searchText)) {
            this.setVisible(false);
            return;
        }
        Object[] options = new Object[]{"Replace", "Skip", "All", "Cancel"};
        final JOptionPane optionPane = new JOptionPane("Do you want to replace this occurence?", 3, 1, null, options, options[0]);
        Frame topFrame = (Frame)this.findTopComponent();
        final JDialog dialog = new JDialog(topFrame, "Replace", true){

            @Override
            protected JRootPane createRootPane() {
                KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
                JRootPane rootPane = new JRootPane();
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        optionPane.setValue("Cancel");
                        this.setVisible(false);
                    }
                };
                rootPane.registerKeyboardAction(actionListener, stroke, 2);
                return rootPane;
            }
        };
        dialog.setContentPane(optionPane);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.pack();
        Object result = null;
        do {
            if (!(found = this.find(false))) continue;
            optionPane.setValue(null);
            dialog.setVisible(true);
            result = optionPane.getValue();
            if ("Replace".equals(result)) {
                this.textComponent.replaceSelection(replaceText);
                continue;
            }
            if (!"All".equals(result)) continue;
            int count = 0;
            do {
                this.textComponent.replaceSelection(replaceText);
                ++count;
            } while (found = this.find(false, false));
            JOptionPane.showMessageDialog(topFrame, count + " occurence(s) replaced.", "Information", 1);
        } while (found && !"All".equals(result) && !"Cancel".equals(result));
    }

    public String getSearchText() {
        return (String)this.searchComboBox.getSelectedItem();
    }

    public void setTextComponent(JTextComponent textComponent) {
        this.textComponent = textComponent;
    }

    public void findNext(JTextComponent textComponent) {
        this.setTextComponent(textComponent);
        this.find(false);
    }

    public void findPrev(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.find(true);
    }

    public static void main(String[] args) {
        String s = "1ABCDEEEEHIEUIRFEEewgfuiewhf";
        Pattern pattern = Pattern.compile("\\d", 96);
        Matcher matcher = pattern.matcher(s);
        boolean found = matcher.find();
        if (found) {
            System.out.println(matcher.start() + ", " + matcher.end());
        }
    }

    @Override
    protected void onOk() {
        if (this.operation == 1) {
            this.find(false);
        } else {
            this.replace(false);
        }
    }
}

