/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.analysis.CharFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TrieTokenizerFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.TextResponseWriter;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDateFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.DoubleFieldSource;
import org.apache.solr.search.function.FloatFieldSource;
import org.apache.solr.search.function.IntFieldSource;
import org.apache.solr.search.function.LongFieldSource;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieField
extends FieldType {
    public static final int DEFAULT_PRECISION_STEP = 8;
    protected int precisionStepArg = 8;
    protected int precisionStep;
    protected TrieTypes type;
    static final DateField dateField = new DateField();
    static final String INT_PREFIX = new String(new char[]{'`'});
    static final String LONG_PREFIX = new String(new char[]{' '});

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        String t;
        String p = args.remove("precisionStep");
        if (p != null) {
            this.precisionStepArg = Integer.parseInt(p);
        }
        this.precisionStep = this.precisionStepArg;
        if (this.precisionStep <= 0 || this.precisionStep >= 64) {
            this.precisionStep = Integer.MAX_VALUE;
        }
        if ((t = args.remove("type")) != null) {
            try {
                this.type = TrieTypes.valueOf(t.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid type specified in schema.xml for field: " + args.get("name"), (Throwable)e);
            }
        }
        CharFilterFactory[] filterFactories = new CharFilterFactory[]{};
        TokenFilterFactory[] tokenFilterFactories = new TokenFilterFactory[]{};
        this.analyzer = new TokenizerChain(filterFactories, new TrieTokenizerFactory(this.type, this.precisionStep), tokenFilterFactories);
        this.queryAnalyzer = new TokenizerChain(filterFactories, new TrieTokenizerFactory(this.type, Integer.MAX_VALUE), tokenFilterFactories);
    }

    @Override
    public Object toObject(Fieldable f) {
        byte[] arr = f.binaryValue();
        if (arr == null) {
            return TrieField.badFieldString(f);
        }
        switch (this.type) {
            case INTEGER: {
                return TrieField.toInt(arr);
            }
            case FLOAT: {
                return Float.valueOf(TrieField.toFloat(arr));
            }
            case LONG: {
                return TrieField.toLong(arr);
            }
            case DOUBLE: {
                return TrieField.toDouble(arr);
            }
            case DATE: {
                return new Date(TrieField.toLong(arr));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        switch (this.type) {
            case INTEGER: {
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_INT_PARSER, top);
            }
            case FLOAT: {
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_FLOAT_PARSER, top);
            }
            case LONG: 
            case DATE: {
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_LONG_PARSER, top);
            }
            case DOUBLE: {
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_DOUBLE_PARSER, top);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + field.name);
    }

    @Override
    public ValueSource getValueSource(SchemaField field) {
        switch (this.type) {
            case INTEGER: {
                return new IntFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_INT_PARSER);
            }
            case FLOAT: {
                return new FloatFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_FLOAT_PARSER);
            }
            case DATE: {
                return new TrieDateFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_LONG_PARSER);
            }
            case LONG: {
                return new LongFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_LONG_PARSER);
            }
            case DOUBLE: {
                return new DoubleFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_DOUBLE_PARSER);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + field.name);
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        byte[] arr = f.binaryValue();
        if (arr == null) {
            xmlWriter.writeStr(name, TrieField.badFieldString(f));
            return;
        }
        switch (this.type) {
            case INTEGER: {
                xmlWriter.writeInt(name, TrieField.toInt(arr));
                break;
            }
            case FLOAT: {
                xmlWriter.writeFloat(name, TrieField.toFloat(arr));
                break;
            }
            case LONG: {
                xmlWriter.writeLong(name, TrieField.toLong(arr));
                break;
            }
            case DOUBLE: {
                xmlWriter.writeDouble(name, TrieField.toDouble(arr));
                break;
            }
            case DATE: {
                xmlWriter.writeDate(name, new Date(TrieField.toLong(arr)));
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
            }
        }
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        byte[] arr = f.binaryValue();
        if (arr == null) {
            writer.writeStr(name, TrieField.badFieldString(f), true);
            return;
        }
        switch (this.type) {
            case INTEGER: {
                writer.writeInt(name, TrieField.toInt(arr));
                break;
            }
            case FLOAT: {
                writer.writeFloat(name, TrieField.toFloat(arr));
                break;
            }
            case LONG: {
                writer.writeLong(name, TrieField.toLong(arr));
                break;
            }
            case DOUBLE: {
                writer.writeDouble(name, TrieField.toDouble(arr));
                break;
            }
            case DATE: {
                writer.writeDate(name, new Date(TrieField.toLong(arr)));
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
            }
        }
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    @Override
    public boolean multiValuedFieldCache() {
        return false;
    }

    public int getPrecisionStep() {
        return this.precisionStepArg;
    }

    public TrieTypes getType() {
        return this.type;
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        int ps = this.precisionStep;
        NumericRangeQuery query = null;
        switch (this.type) {
            case INTEGER: {
                query = NumericRangeQuery.newIntRange((String)field.getName(), (int)ps, (Integer)(min == null ? null : Integer.valueOf(Integer.parseInt(min))), (Integer)(max == null ? null : Integer.valueOf(Integer.parseInt(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case FLOAT: {
                query = NumericRangeQuery.newFloatRange((String)field.getName(), (int)ps, (Float)(min == null ? null : Float.valueOf(Float.parseFloat(min))), (Float)(max == null ? null : Float.valueOf(Float.parseFloat(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case LONG: {
                query = NumericRangeQuery.newLongRange((String)field.getName(), (int)ps, (Long)(min == null ? null : Long.valueOf(Long.parseLong(min))), (Long)(max == null ? null : Long.valueOf(Long.parseLong(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case DOUBLE: {
                query = NumericRangeQuery.newDoubleRange((String)field.getName(), (int)ps, (Double)(min == null ? null : Double.valueOf(Double.parseDouble(min))), (Double)(max == null ? null : Double.valueOf(Double.parseDouble(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case DATE: {
                query = NumericRangeQuery.newLongRange((String)field.getName(), (int)ps, (Long)(min == null ? null : Long.valueOf(dateField.parseMath(null, min).getTime())), max == null ? null : Long.valueOf(dateField.parseMath(null, max).getTime()), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field");
            }
        }
        return query;
    }

    static int toInt(byte[] arr) {
        return arr[0] << 24 | (arr[1] & 0xFF) << 16 | (arr[2] & 0xFF) << 8 | arr[3] & 0xFF;
    }

    static long toLong(byte[] arr) {
        int high = arr[0] << 24 | (arr[1] & 0xFF) << 16 | (arr[2] & 0xFF) << 8 | arr[3] & 0xFF;
        int low = arr[4] << 24 | (arr[5] & 0xFF) << 16 | (arr[6] & 0xFF) << 8 | arr[7] & 0xFF;
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    static float toFloat(byte[] arr) {
        return Float.intBitsToFloat(TrieField.toInt(arr));
    }

    static double toDouble(byte[] arr) {
        return Double.longBitsToDouble(TrieField.toLong(arr));
    }

    static byte[] toArr(int val) {
        byte[] arr = new byte[]{(byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        return arr;
    }

    static byte[] toArr(long val) {
        byte[] arr = new byte[]{(byte)(val >>> 56), (byte)(val >>> 48), (byte)(val >>> 40), (byte)(val >>> 32), (byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        return arr;
    }

    static byte[] toArr(float val) {
        return TrieField.toArr(Float.floatToRawIntBits(val));
    }

    static byte[] toArr(double val) {
        return TrieField.toArr(Double.doubleToRawLongBits(val));
    }

    @Override
    public String storedToReadable(Fieldable f) {
        return this.toExternal(f);
    }

    @Override
    public String readableToIndexed(String val) {
        switch (this.type) {
            case INTEGER: {
                return NumericUtils.intToPrefixCoded((int)Integer.parseInt(val));
            }
            case FLOAT: {
                return NumericUtils.intToPrefixCoded((int)NumericUtils.floatToSortableInt((float)Float.parseFloat(val)));
            }
            case LONG: {
                return NumericUtils.longToPrefixCoded((long)Long.parseLong(val));
            }
            case DOUBLE: {
                return NumericUtils.longToPrefixCoded((long)NumericUtils.doubleToSortableLong((double)Double.parseDouble(val)));
            }
            case DATE: {
                return NumericUtils.longToPrefixCoded((long)dateField.parseMath(null, val).getTime());
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
    }

    @Override
    public String toInternal(String val) {
        return this.readableToIndexed(val);
    }

    static String badFieldString(Fieldable f) {
        String s = f.stringValue();
        return "ERROR:SCHEMA-INDEX-MISMATCH,stringValue=" + s;
    }

    @Override
    public String toExternal(Fieldable f) {
        byte[] arr = f.binaryValue();
        if (arr == null) {
            return TrieField.badFieldString(f);
        }
        switch (this.type) {
            case INTEGER: {
                return Integer.toString(TrieField.toInt(arr));
            }
            case FLOAT: {
                return Float.toString(TrieField.toFloat(arr));
            }
            case LONG: {
                return Long.toString(TrieField.toLong(arr));
            }
            case DOUBLE: {
                return Double.toString(TrieField.toDouble(arr));
            }
            case DATE: {
                return dateField.formatDate(new Date(TrieField.toLong(arr)));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        switch (this.type) {
            case INTEGER: {
                return Integer.toString(NumericUtils.prefixCodedToInt((String)indexedForm));
            }
            case FLOAT: {
                return Float.toString(NumericUtils.sortableIntToFloat((int)NumericUtils.prefixCodedToInt((String)indexedForm)));
            }
            case LONG: {
                return Long.toString(NumericUtils.prefixCodedToLong((String)indexedForm));
            }
            case DOUBLE: {
                return Double.toString(NumericUtils.sortableLongToDouble((long)NumericUtils.prefixCodedToLong((String)indexedForm)));
            }
            case DATE: {
                return dateField.formatDate(new Date(NumericUtils.prefixCodedToLong((String)indexedForm)));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
    }

    @Override
    public String storedToIndexed(Fieldable f) {
        return this.readableToIndexed(this.storedToReadable(f));
    }

    @Override
    public Field createField(SchemaField field, String externalVal, float boost) {
        Field f;
        boolean indexed = field.indexed();
        boolean stored = field.stored();
        if (!indexed && !stored) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        int ps = this.precisionStep;
        byte[] arr = null;
        NumericTokenStream ts = null;
        switch (this.type) {
            case INTEGER: {
                int i = Integer.parseInt(externalVal);
                if (stored) {
                    arr = TrieField.toArr(i);
                }
                if (!indexed) break;
                ts = new NumericTokenStream(ps).setIntValue(i);
                break;
            }
            case FLOAT: {
                float f2 = Float.parseFloat(externalVal);
                if (stored) {
                    arr = TrieField.toArr(f2);
                }
                if (!indexed) break;
                ts = new NumericTokenStream(ps).setFloatValue(f2);
                break;
            }
            case LONG: {
                long l = Long.parseLong(externalVal);
                if (stored) {
                    arr = TrieField.toArr(l);
                }
                if (!indexed) break;
                ts = new NumericTokenStream(ps).setLongValue(l);
                break;
            }
            case DOUBLE: {
                double d = Double.parseDouble(externalVal);
                if (stored) {
                    arr = TrieField.toArr(d);
                }
                if (!indexed) break;
                ts = new NumericTokenStream(ps).setDoubleValue(d);
                break;
            }
            case DATE: {
                long time = dateField.parseMath(null, externalVal).getTime();
                if (stored) {
                    arr = TrieField.toArr(time);
                }
                if (!indexed) break;
                ts = new NumericTokenStream(ps).setLongValue(time);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
        if (stored) {
            f = new Field(field.getName(), arr, Field.Store.YES);
            if (indexed) {
                f.setTokenStream((TokenStream)ts);
            }
        } else {
            f = new Field(field.getName(), (TokenStream)ts);
        }
        f.setOmitNorms(field.omitNorms());
        f.setOmitTermFreqAndPositions(field.omitTf());
        f.setBoost(boost);
        return f;
    }

    public static String getMainValuePrefix(FieldType ft) {
        if (ft instanceof TrieDateField) {
            int step = ((TrieDateField)ft).getPrecisionStep();
            if (step <= 0 || step >= 64) {
                return null;
            }
            return LONG_PREFIX;
        }
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            if (trie.precisionStep == Integer.MAX_VALUE) {
                return null;
            }
            switch (trie.type) {
                case INTEGER: 
                case FLOAT: {
                    return INT_PREFIX;
                }
                case LONG: 
                case DOUBLE: 
                case DATE: {
                    return LONG_PREFIX;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)trie.type));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TrieTypes {
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        DATE;

    }
}

