/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.recovery.Listener;
import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;

public class TransactionStatusManager {
    private Listener _listener;
    private static final String _defaultTsmService = "com.arjuna.ats.arjuna.recovery.ActionStatusService";
    private boolean _finalizeCalled = false;
    private ServerSocket _socket;
    private int _port = 0;
    private int DEFAULT_TMS_PORT = 0;

    public TransactionStatusManager() {
        this.start(_defaultTsmService, null, -1);
    }

    public TransactionStatusManager(int port) {
        this.start(_defaultTsmService, null, port);
    }

    public TransactionStatusManager(String serviceName) {
        this.start(serviceName, null, -1);
    }

    public TransactionStatusManager(String serviceName, int port) {
        this.start(serviceName, null, port);
    }

    private void addService(Service service, ServerSocket serverSocket) {
        try {
            this._listener = new Listener(serverSocket, service);
            this._listener.setDaemon(true);
            if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                tsLogger.arjLoggerI18N.info("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_1", new Object[]{service.getClass().getName(), Integer.toString(serverSocket.getLocalPort())});
            }
            this._listener.start();
        }
        catch (IOException ex) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_2");
        }
    }

    private void start(String serviceName, String host, int port) {
        try {
            Class<?> serviceClass = Thread.currentThread().getContextClassLoader().loadClass(serviceName);
            Service service = (Service)serviceClass.newInstance();
            ServerSocket socketServer = this.getTsmServerSocket(host, port);
            this.addService(service, socketServer);
            TransactionStatusManagerItem.createAndSave(socketServer.getInetAddress().getHostAddress(), socketServer.getLocalPort());
            if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                tsLogger.arjLoggerI18N.info("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_3", new Object[]{Integer.toString(socketServer.getLocalPort()), socketServer.getInetAddress().getHostAddress(), serviceName});
            }
        }
        catch (ClassNotFoundException ex) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_4", new Object[]{serviceName});
            }
        }
        catch (InstantiationException ex) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_5", new Object[]{serviceName});
            }
        }
        catch (IllegalAccessException ex) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_6", new Object[]{serviceName});
            }
        }
        catch (IOException ex) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_14", new Object[]{this.getListenerHostName(), this.getListenerPort(-1)});
            }
            throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_9"), ex);
        }
    }

    public void shutdown() {
        if (this._listener != null) {
            this._listener.stopListener();
            TransactionStatusManagerItem.removeThis(Utility.getProcessUid());
            this._listener = null;
        }
    }

    private int getListenerPort(Integer defValue) {
        if (this._port > 0) {
            return this._port;
        }
        return recoveryPropertyManager.getRecoveryEnvironmentBean().getTransactionStatusManagerPort();
    }

    private String getListenerHostName() {
        return recoveryPropertyManager.getRecoveryEnvironmentBean().getTransactionStatusManagerAddress();
    }

    private ServerSocket getTsmServerSocket(String hostNameOverride, int portOverride) throws IOException {
        if (this._socket != null) {
            return this._socket;
        }
        if (this._port == -1) {
            throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_13"));
        }
        try {
            String host = hostNameOverride == null ? this.getListenerHostName() : hostNameOverride;
            InetAddress bindAddress = Utility.hostNameToInetAddress(host, "com.arjuna.ats.arjuna.recovery.TransactionStatusManager_10");
            this._port = portOverride == -1 ? this.getListenerPort(null) : portOverride;
            this._socket = new ServerSocket(this._port, 50, bindAddress);
            this._port = this._socket.getLocalPort();
        }
        catch (UnknownHostException ex) {
            this._port = -1;
            throw ex;
        }
        return this._socket;
    }
}

