/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.IndependentContext;
import net.sf.saxon.trans.Variable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class Evaluate
extends SystemFunction {
    IndependentContext staticContext;
    InstructionDetails details;
    public static final int EVALUATE = 0;
    public static final int EXPRESSION = 1;
    public static final int EVAL = 2;
    public static final int EVALUATE_NODE = 3;

    protected SequenceType getRequiredType(int n) {
        if (n == 0) {
            return super.getRequiredType(n);
        }
        return SequenceType.ANY_SEQUENCE;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.staticContext == null) {
            super.checkArguments(staticContext);
            if (this.operation == 0 || this.operation == 1) {
                NamespaceResolver namespaceResolver = staticContext.getNamespaceResolver();
                this.staticContext = new IndependentContext(staticContext.getConfiguration());
                this.staticContext.setBaseURI(staticContext.getBaseURI());
                this.staticContext.setImportedSchemaNamespaces(staticContext.getImportedSchemaNamespaces());
                this.staticContext.setDefaultFunctionNamespace(staticContext.getDefaultFunctionNamespace());
                Iterator iterator = namespaceResolver.iteratePrefixes();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = namespaceResolver.getURIForPrefix(string, true);
                    this.staticContext.declareNamespace(string, string2);
                }
                this.details = new InstructionDetails();
                this.details.setConstructType(2051);
                this.details.setSystemId(staticContext.getLocationMap().getSystemId(this.locationId));
                this.details.setLineNumber(staticContext.getLocationMap().getLineNumber(this.locationId));
            } else if (this.operation == 3) {
                this.staticContext = new IndependentContext(staticContext.getConfiguration());
            }
        }
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        if (this.operation == 1 && this.argument[0] instanceof StringValue) {
            Serializable serializable;
            PreparedExpression preparedExpression = new PreparedExpression();
            String string = ((StringValue)this.argument[0]).getStringValue();
            preparedExpression.variables = new Variable[10];
            for (int i = 1; i < 10; ++i) {
                serializable = new QNameValue("", "", "p" + i, null);
                preparedExpression.variables[i - 1] = this.staticContext.declareVariable((QNameValue)serializable);
            }
            Expression expression = ExpressionTool.make(string, this.staticContext, 0, 0, 1);
            serializable = Type.ITEM_TYPE;
            expression = expression.typeCheck(this.staticContext, (ItemType)serializable);
            preparedExpression.stackFrameMap = this.staticContext.getStackFrameMap();
            ExpressionTool.allocateSlots(expression, preparedExpression.stackFrameMap.getNumberOfVariables(), preparedExpression.stackFrameMap);
            preparedExpression.expression = expression;
            return new ObjectValue(preparedExpression);
        }
        return this;
    }

    private PreparedExpression prepareExpression(XPathContext xPathContext) throws XPathException {
        Expression expression;
        Serializable serializable;
        if (this.operation == 2) {
            Item item = this.argument[0].evaluateItem(xPathContext);
            if (!(item instanceof ObjectValue)) {
                this.dynamicError("First argument to saxon:eval must be an expression prepared using saxon:expression", xPathContext);
                return null;
            }
            ObjectValue objectValue = (ObjectValue)item;
            Object object = objectValue.getObject();
            if (!(object instanceof PreparedExpression)) {
                this.dynamicError("First argument to saxon:eval must be an expression prepared using saxon:expression", xPathContext);
                return null;
            }
            return (PreparedExpression)object;
        }
        PreparedExpression preparedExpression = new PreparedExpression();
        if (this.operation == 3) {
            Expression expression2;
            IndependentContext independentContext;
            NodeInfo nodeInfo = (NodeInfo)this.argument[0].evaluateItem(xPathContext);
            preparedExpression.expStaticContext = independentContext = this.staticContext.copy();
            independentContext.setBaseURI(nodeInfo.getBaseURI());
            independentContext.setFunctionLibrary(this.getExecutable().getFunctionLibrary());
            independentContext.setNamespaces(nodeInfo);
            String string = nodeInfo.getStringValue();
            AxisIterator axisIterator = SingletonIterator.makeIterator(nodeInfo);
            axisIterator.next();
            xPathContext.setCurrentIterator(axisIterator);
            try {
                expression2 = ExpressionTool.make(string, independentContext, 0, 0, 1);
            }
            catch (XPathException xPathException) {
                String string2 = xPathContext.getNamePool().getDisplayName(this.getFunctionNameCode());
                DynamicError dynamicError = new DynamicError("Static error in XPath expression supplied to " + string2 + ": " + xPathException.getMessage().trim());
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            ItemType itemType = Type.ITEM_TYPE;
            expression2 = expression2.typeCheck(independentContext, itemType);
            preparedExpression.stackFrameMap = independentContext.getStackFrameMap();
            ExpressionTool.allocateSlots(expression2, preparedExpression.stackFrameMap.getNumberOfVariables(), preparedExpression.stackFrameMap);
            preparedExpression.expression = expression2;
            if (expression2 instanceof ComputedExpression) {
                ((ComputedExpression)expression2).setParentExpression(this);
            }
            return preparedExpression;
        }
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        String string = atomicValue.getStringValue();
        IndependentContext independentContext = this.staticContext.copy();
        independentContext.setFunctionLibrary(this.getExecutable().getFunctionLibrary());
        preparedExpression.expStaticContext = independentContext;
        preparedExpression.variables = new Variable[10];
        for (int i = 1; i < 10; ++i) {
            serializable = new QNameValue("", "", "p" + i, null);
            preparedExpression.variables[i - 1] = independentContext.declareVariable((QNameValue)serializable);
        }
        try {
            expression = ExpressionTool.make(string, independentContext, 0, 0, 1);
        }
        catch (XPathException xPathException) {
            String string3 = xPathContext.getNamePool().getDisplayName(this.getFunctionNameCode());
            DynamicError dynamicError = new DynamicError("Static error in XPath expression supplied to " + string3 + ": " + xPathException.getMessage().trim());
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        serializable = Type.ITEM_TYPE;
        expression = expression.typeCheck(independentContext, (ItemType)serializable);
        preparedExpression.stackFrameMap = independentContext.getStackFrameMap();
        ExpressionTool.allocateSlots(expression, preparedExpression.stackFrameMap.getNumberOfVariables(), preparedExpression.stackFrameMap);
        preparedExpression.expression = expression;
        return preparedExpression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.operation == 1) {
            PreparedExpression preparedExpression = this.prepareExpression(xPathContext);
            return new ObjectValue(preparedExpression);
        }
        if (this.operation == 3) {
            XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
            PreparedExpression preparedExpression = this.prepareExpression(xPathContextMajor);
            xPathContextMajor.setOrigin(this.details);
            xPathContextMajor.openStackFrame(preparedExpression.stackFrameMap);
            return preparedExpression.expression.evaluateItem(xPathContextMajor);
        }
        PreparedExpression preparedExpression = this.prepareExpression(xPathContext);
        for (int i = 1; i < this.argument.length; ++i) {
            preparedExpression.variables[i - 1].setXPathValue(ExpressionTool.eagerEvaluate(this.argument[i], xPathContext));
        }
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this.details);
        xPathContextMajor.openStackFrame(preparedExpression.stackFrameMap);
        xPathContextMajor.setCurrentIterator(xPathContext.getCurrentIterator());
        return preparedExpression.expression.evaluateItem(xPathContextMajor);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        PreparedExpression preparedExpression = this.prepareExpression(xPathContext);
        if (this.operation == 1) {
            return SingletonIterator.makeIterator(new ObjectValue(preparedExpression));
        }
        for (int i = 1; i < this.argument.length; ++i) {
            preparedExpression.variables[i - 1].setXPathValue(ExpressionTool.eagerEvaluate(this.argument[i], xPathContext));
        }
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this.details);
        xPathContextMajor.openStackFrame(preparedExpression.stackFrameMap);
        xPathContextMajor.setCurrentIterator(xPathContext.getCurrentIterator());
        return Value.getIterator(ExpressionTool.lazyEvaluate(preparedExpression.expression, xPathContextMajor, 1));
    }

    public int getIntrinsicDependencies() {
        return 30;
    }

    public static class PreparedExpression
    implements Serializable {
        public IndependentContext expStaticContext;
        public Expression expression;
        public Variable[] variables;
        public SlotManager stackFrameMap;
    }
}

