/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.addons.importexport.ExportTask;
import org.nuiton.wikitty.addons.importexport.ImportExportCSV;
import org.nuiton.wikitty.addons.importexport.ImportExportMethod;
import org.nuiton.wikitty.addons.importexport.ImportExportXML;
import org.nuiton.wikitty.addons.importexport.ImportTask;
import org.nuiton.wikitty.addons.importexport.JobState;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;

public class WikittyImportExportService {
    ApplicationConfig config = null;
    protected String exportDirectory = "/tmp/";
    protected String exportPublicURL = "file:///tmp/";
    protected ExecutorService importExportExecutor;
    protected Map<String, Future<String>> importExportTask = new HashMap<String, Future<String>>();
    protected WikittyService ws;
    protected String securityToken;

    public WikittyImportExportService(ApplicationConfig config, String securityToken, WikittyService ws) {
        this.config = config;
        this.securityToken = securityToken;
        this.ws = ws;
        this.exportDirectory = config.getOption(WikittyConfig.WikittyOption.WIKITTY_EXPORT_DIRECTORY.getKey());
        this.exportPublicURL = config.getOption(WikittyConfig.WikittyOption.WIKITTY_EXPORT_PUBLICURL.getKey());
        int maxThread = config.getOptionAsInt(WikittyConfig.WikittyOption.WIKITTY_EXPORT_THREADNUMBER.getKey());
        this.importExportExecutor = Executors.newFixedThreadPool(maxThread);
    }

    public WikittyService getWikittyService() {
        return this.ws;
    }

    public String getExportDirectory() {
        return this.exportDirectory;
    }

    public String getExportPublicURL() {
        return this.exportPublicURL;
    }

    public void syncImport(FORMAT format, String s) {
        StringReader reader = new StringReader(s);
        ImportTask task = new ImportTask(this.securityToken, this.config, this.ws, format, reader);
        task.run();
    }

    public void syncImportFromUri(FORMAT format, String uri) {
        try {
            URL url = new URL(uri);
            InputStreamReader reader = new InputStreamReader(url.openStream());
            ImportTask task = new ImportTask(this.securityToken, this.config, this.ws, format, reader);
            task.run();
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't import in format %s uri %s", new Object[]{format, uri}), eee);
        }
    }

    public String asyncImportFromUri(FORMAT format, String uri) {
        try {
            URL url = new URL(uri);
            InputStreamReader reader = new InputStreamReader(url.openStream());
            ImportTask task = new ImportTask(this.securityToken, this.config, this.ws, format, reader);
            FutureTask<Object> future = new FutureTask<Object>(task, null);
            this.importExportExecutor.submit(future);
            String jobId = UUID.randomUUID().toString();
            this.importExportTask.put(jobId, future);
            return jobId;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't import in format %s uri %s", new Object[]{format, uri}), eee);
        }
    }

    public String asyncExportAllByExample(FORMAT format, BusinessEntityImpl e) {
        Criteria criteria = Search.query(e.getWikitty()).criteria();
        String result = this.asyncExportAllByCriteria(format, criteria);
        return result;
    }

    public String syncExportAllByExample(FORMAT format, BusinessEntityImpl e) {
        Criteria criteria = Search.query(e.getWikitty()).criteria();
        String result = this.syncExportAllByCriteria(format, criteria);
        return result;
    }

    public String asyncExportAllByCriteria(FORMAT format, Criteria criteria) {
        try {
            String jobId = UUID.randomUUID().toString();
            File file = new File(this.exportDirectory, jobId);
            String url = this.exportPublicURL + jobId;
            FileWriter result = new FileWriter(file);
            ExportTask task = new ExportTask(this.securityToken, this.ws, format, criteria, result);
            FutureTask<String> future = new FutureTask<String>(task, url);
            this.importExportExecutor.submit(future);
            this.importExportTask.put(jobId, future);
            return jobId;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't export in format %s", new Object[]{format}), eee);
        }
    }

    public String syncExportAllByCriteria(FORMAT format, Criteria criteria) {
        StringWriter result = new StringWriter();
        ExportTask task = new ExportTask(this.securityToken, this.ws, format, criteria, result);
        task.run();
        return result.toString();
    }

    public JobState infoJob(String jobId) {
        try {
            Future<String> future = this.importExportTask.get(jobId);
            JobState result = new JobState();
            if (future.isDone()) {
                result.status = "done";
                result.resourceUri = future.get();
            } else {
                result.status = future.isCancelled() ? "cancelled" : "inProgress";
            }
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't retrieve job info for job %s", jobId), eee);
        }
    }

    public void cancelJob(String jobId) {
        Future<String> future = this.importExportTask.get(jobId);
        future.cancel(true);
    }

    public void freeJobResource(String jobId) {
        Future<String> future = this.importExportTask.remove(jobId);
        if (future != null) {
            File file = new File(this.exportDirectory, jobId);
            file.delete();
        }
    }

    public static enum FORMAT {
        XML(new ImportExportXML()),
        CSV(new ImportExportCSV());

        protected ImportExportMethod ieporter;

        private FORMAT(ImportExportMethod ieporter) {
            this.ieporter = ieporter;
        }

        public ImportExportMethod ieporter() {
            return this.ieporter;
        }
    }
}

