/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.command.dml.Optimizer;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectListColumnResolver;
import org.h2.command.dml.SelectOrderBy;
import org.h2.constant.SysProperties;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Alias;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.Wildcard;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Select
extends Query {
    private TableFilter topTableFilter;
    private ObjectArray<TableFilter> filters = ObjectArray.newInstance();
    private ObjectArray<TableFilter> topFilters = ObjectArray.newInstance();
    private ObjectArray<Expression> expressions;
    private Expression having;
    private Expression condition;
    private int visibleColumnCount;
    private int distinctColumnCount;
    private ObjectArray<SelectOrderBy> orderList;
    private ObjectArray<Expression> group;
    private int[] groupIndex;
    private boolean[] groupByExpression;
    private boolean distinct;
    private HashMap<Expression, Object> currentGroup;
    private int havingIndex;
    private boolean isGroupQuery;
    private boolean isGroupSortedQuery;
    private boolean isForUpdate;
    private double cost;
    private boolean isQuickAggregateQuery;
    private boolean isDistinctQuery;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean sortUsingIndex;
    private SortOrder sort;
    private int currentGroupRowId;

    public Select(Session session) {
        super(session);
    }

    public void addTableFilter(TableFilter tableFilter, boolean bl) {
        this.filters.add(tableFilter);
        if (bl) {
            this.topFilters.add(tableFilter);
        }
    }

    public ObjectArray<TableFilter> getTopFilters() {
        return this.topFilters;
    }

    public void setExpressions(ObjectArray<Expression> objectArray) {
        this.expressions = objectArray;
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setGroupBy(ObjectArray<Expression> objectArray) {
        this.group = objectArray;
    }

    public HashMap<Expression, Object> getCurrentGroup() {
        return this.currentGroup;
    }

    public int getCurrentGroupRowId() {
        return this.currentGroupRowId;
    }

    @Override
    public void setOrder(ObjectArray<SelectOrderBy> objectArray) {
        this.orderList = objectArray;
    }

    public void addCondition(Expression expression) {
        this.condition = this.condition == null ? expression : new ConditionAndOr(0, expression, this.condition);
    }

    private void queryGroupSorted(int n, LocalResult localResult) throws SQLException {
        int n2 = 0;
        this.setCurrentRowNumber(0);
        Object[] objectArray = null;
        while (this.topTableFilter.next()) {
            int n3;
            this.setCurrentRowNumber(n2 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++n2;
            Object[] objectArray2 = new Value[this.groupIndex.length];
            for (n3 = 0; n3 < this.groupIndex.length; ++n3) {
                int n4 = this.groupIndex[n3];
                Expression expression = this.expressions.get(n4);
                objectArray2[n3] = expression.getValue(this.session);
            }
            if (objectArray == null) {
                objectArray = objectArray2;
                this.currentGroup = New.hashMap();
            } else if (!Arrays.equals(objectArray, objectArray2)) {
                this.addGroupSortedRow((Value[])objectArray, n, localResult);
                objectArray = objectArray2;
                this.currentGroup = New.hashMap();
            }
            ++this.currentGroupRowId;
            for (n3 = 0; n3 < n; ++n3) {
                if (this.groupByExpression != null && this.groupByExpression[n3]) continue;
                Expression expression = this.expressions.get(n3);
                expression.updateAggregate(this.session);
            }
        }
        if (objectArray != null) {
            this.addGroupSortedRow((Value[])objectArray, n, localResult);
        }
    }

    private void addGroupSortedRow(Value[] valueArray, int n, LocalResult localResult) throws SQLException {
        int n2;
        Value[] valueArray2 = new Value[n];
        for (n2 = 0; this.groupIndex != null && n2 < this.groupIndex.length; ++n2) {
            valueArray2[this.groupIndex[n2]] = valueArray[n2];
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (this.groupByExpression != null && this.groupByExpression[n2]) continue;
            Expression expression = this.expressions.get(n2);
            valueArray2[n2] = expression.getValue(this.session);
        }
        if (this.isHavingNullOrFalse(valueArray2)) {
            return;
        }
        valueArray2 = this.keepOnlyDistinct(valueArray2, n);
        localResult.addRow(valueArray2);
    }

    private Value[] keepOnlyDistinct(Value[] valueArray, int n) {
        if (n == this.distinctColumnCount) {
            return valueArray;
        }
        Object[] objectArray = new Value[this.distinctColumnCount];
        ObjectUtils.arrayCopy(valueArray, objectArray, this.distinctColumnCount);
        return objectArray;
    }

    private boolean isHavingNullOrFalse(Value[] valueArray) throws SQLException {
        if (this.havingIndex >= 0) {
            Value value = valueArray[this.havingIndex];
            if (value == ValueNull.INSTANCE) {
                return true;
            }
            if (!Boolean.TRUE.equals(value.getBoolean())) {
                return true;
            }
        }
        return false;
    }

    private Index getGroupSortedIndex() {
        if (this.groupIndex == null || this.groupByExpression == null) {
            return null;
        }
        ObjectArray<Index> objectArray = this.topTableFilter.getTable().getIndexes();
        for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
            Index index = objectArray.get(i);
            if (index.getIndexType().isScan() || !this.isGroupSortedIndex(this.topTableFilter, index)) continue;
            return index;
        }
        return null;
    }

    private boolean isGroupSortedIndex(TableFilter tableFilter, Index index) {
        int n;
        Column[] columnArray = index.getColumns();
        boolean[] blArray = new boolean[columnArray.length];
        block0: for (n = 0; n < this.expressions.size(); ++n) {
            if (!this.groupByExpression[n]) continue;
            Expression expression = this.expressions.get(n);
            if (!(expression instanceof ExpressionColumn)) {
                return false;
            }
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            for (int i = 0; i < columnArray.length; ++i) {
                if (tableFilter != expressionColumn.getTableFilter() || !columnArray[i].equals(expressionColumn.getColumn())) continue;
                blArray[i] = true;
                continue block0;
            }
            return false;
        }
        for (n = 1; n < blArray.length; ++n) {
            if (blArray[n - 1] || !blArray[n]) continue;
            return false;
        }
        return true;
    }

    private int getGroupByExpressionCount() {
        if (this.groupByExpression == null) {
            return 0;
        }
        int n = 0;
        for (boolean bl : this.groupByExpression) {
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    private void queryGroup(int n, LocalResult localResult) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        ValueHashMap valueHashMap = ValueHashMap.newInstance(this.session.getDatabase());
        int n2 = 0;
        this.setCurrentRowNumber(0);
        ValueArray valueArray = ValueArray.get(new Value[0]);
        while (this.topTableFilter.next()) {
            int n3;
            int n4;
            this.setCurrentRowNumber(n2 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++n2;
            if (this.groupIndex == null) {
                object3 = valueArray;
            } else {
                object2 = new Value[this.groupIndex.length];
                for (n4 = 0; n4 < this.groupIndex.length; ++n4) {
                    n3 = this.groupIndex[n4];
                    object = this.expressions.get(n3);
                    object2[n4] = ((Expression)object).getValue(this.session);
                }
                object3 = ValueArray.get(object2);
            }
            object2 = (HashMap)valueHashMap.get((Value)object3);
            if (object2 == null) {
                object2 = new HashMap();
                valueHashMap.put((Value)object3, object2);
            }
            this.currentGroup = object2;
            ++this.currentGroupRowId;
            n4 = n;
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.groupByExpression != null && this.groupByExpression[n3]) continue;
                object = this.expressions.get(n3);
                ((Expression)object).updateAggregate(this.session);
            }
            if (this.sampleSize <= 0 || n2 < this.sampleSize) continue;
            break;
        }
        if (this.groupIndex == null && valueHashMap.size() == 0) {
            valueHashMap.put(valueArray, new HashMap());
        }
        object3 = valueHashMap.keys();
        object2 = ((ObjectArray)object3).iterator();
        while (object2.hasNext()) {
            int n5;
            Value value = object2.next();
            ValueArray valueArray2 = (ValueArray)value;
            this.currentGroup = (HashMap)valueHashMap.get(valueArray2);
            object = valueArray2.getList();
            Value[] valueArray3 = new Value[n];
            for (n5 = 0; this.groupIndex != null && n5 < this.groupIndex.length; ++n5) {
                valueArray3[this.groupIndex[n5]] = object[n5];
            }
            for (n5 = 0; n5 < n; ++n5) {
                if (this.groupByExpression != null && this.groupByExpression[n5]) continue;
                Expression expression = this.expressions.get(n5);
                valueArray3[n5] = expression.getValue(this.session);
            }
            if (this.isHavingNullOrFalse(valueArray3)) continue;
            valueArray3 = this.keepOnlyDistinct(valueArray3, n);
            localResult.addRow(valueArray3);
        }
    }

    private Index getSortIndex() throws SQLException {
        IndexColumn[] indexColumnArray;
        Object object;
        if (this.sort == null) {
            return null;
        }
        ObjectArray<Column> objectArray = ObjectArray.newInstance();
        for (int n : this.sort.getIndexes()) {
            if (n < 0 || n >= this.expressions.size()) {
                throw Message.getInvalidValueException("" + (n + 1), "ORDER BY");
            }
            object = this.expressions.get(n);
            if (((Expression)(object = ((Expression)object).getNonAliasExpression())).isConstant()) continue;
            if (!(object instanceof ExpressionColumn)) {
                return null;
            }
            indexColumnArray = (IndexColumn[])object;
            if (indexColumnArray.getTableFilter() != this.topTableFilter) {
                return null;
            }
            objectArray.add(indexColumnArray.getColumn());
        }
        Column[] columnArray = objectArray.toArray(new Column[objectArray.size()]);
        int[] nArray = this.sort.getSortTypes();
        if (columnArray.length == 0) {
            return this.topTableFilter.getTable().getScanIndex(this.session);
        }
        ObjectArray<Index> objectArray2 = this.topTableFilter.getTable().getIndexes();
        for (int n = 0; objectArray2 != null && n < objectArray2.size(); ++n) {
            object = objectArray2.get(n);
            if (object.getCreateSQL() == null || object.getIndexType().isHash() || (indexColumnArray = object.getIndexColumns()).length < columnArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < columnArray.length; ++i) {
                IndexColumn indexColumn = indexColumnArray[i];
                Column column = columnArray[i];
                if (indexColumn.column != column) {
                    bl = false;
                    break;
                }
                if (indexColumn.sortType == nArray[i]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return object;
        }
        return null;
    }

    private void queryDistinct(LocalResult localResult, long l) throws SQLException {
        if (l != 0L && this.offsetExpr != null) {
            l += (long)this.offsetExpr.getValue(this.session).getInt();
        }
        int n = 0;
        this.setCurrentRowNumber(0);
        Index index = this.topTableFilter.getIndex();
        SearchRow searchRow = null;
        int n2 = index.getColumns()[0].getColumnId();
        do {
            this.setCurrentRowNumber(n + 1);
            Cursor cursor = index.findNext(this.session, searchRow, null);
            if (!cursor.next()) break;
            SearchRow searchRow2 = cursor.getSearchRow();
            Value value = searchRow2.getValue(n2);
            if (searchRow == null) {
                searchRow = this.topTableFilter.getTable().getTemplateSimpleRow(true);
            }
            searchRow.setValue(n2, value);
            Value[] valueArray = new Value[]{value};
            localResult.addRow(valueArray);
        } while ((this.sort != null && !this.sortUsingIndex || l == 0L || (long)localResult.getRowCount() < l) && (this.sampleSize <= 0 || ++n < this.sampleSize));
    }

    private void queryFlat(int n, LocalResult localResult, long l) throws SQLException {
        if (l != 0L && this.offsetExpr != null) {
            l += (long)this.offsetExpr.getValue(this.session).getInt();
        }
        int n2 = 0;
        this.setCurrentRowNumber(0);
        while (this.topTableFilter.next()) {
            this.setCurrentRowNumber(n2 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            Value[] valueArray = new Value[n];
            for (int i = 0; i < n; ++i) {
                Expression expression = this.expressions.get(i);
                valueArray[i] = expression.getValue(this.session);
            }
            localResult.addRow(valueArray);
            if ((this.sort != null && !this.sortUsingIndex || l == 0L || (long)localResult.getRowCount() < l) && (this.sampleSize <= 0 || ++n2 < this.sampleSize)) continue;
            break;
        }
    }

    private void queryQuick(int n, LocalResult localResult) throws SQLException {
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            Expression expression = this.expressions.get(i);
            valueArray[i] = expression.getValue(this.session);
        }
        localResult.addRow(valueArray);
    }

    @Override
    public ResultInterface queryMeta() throws SQLException {
        LocalResult localResult = new LocalResult(this.session, this.expressions, this.visibleColumnCount);
        localResult.done();
        return localResult;
    }

    @Override
    protected LocalResult queryWithoutCache(int n) throws SQLException {
        int n2;
        int n3 = n;
        if (this.limitExpr != null) {
            n2 = this.limitExpr.getValue(this.session).getInt();
            n3 = n3 == 0 ? n2 : Math.min(n2, n3);
        }
        n2 = this.expressions.size();
        LocalResult localResult = new LocalResult(this.session, this.expressions, this.visibleColumnCount);
        if (!this.sortUsingIndex) {
            localResult.setSortOrder(this.sort);
        }
        if (this.distinct && !this.isDistinctQuery) {
            localResult.setDistinct();
        }
        this.topTableFilter.startQuery(this.session);
        this.topTableFilter.reset();
        this.topTableFilter.lock(this.session, this.isForUpdate, this.isForUpdate);
        if (this.isQuickAggregateQuery) {
            this.queryQuick(n2, localResult);
        } else if (this.isGroupQuery) {
            if (this.isGroupSortedQuery) {
                this.queryGroupSorted(n2, localResult);
            } else {
                this.queryGroup(n2, localResult);
            }
        } else if (this.isDistinctQuery) {
            this.queryDistinct(localResult, n3);
        } else {
            this.queryFlat(n2, localResult, n3);
        }
        if (this.offsetExpr != null) {
            localResult.setOffset(this.offsetExpr.getValue(this.session).getInt());
        }
        if (n3 != 0) {
            localResult.setLimit(n3);
        }
        localResult.done();
        return localResult;
    }

    private void expandColumnList() throws SQLException {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Object object;
            Expression expression = this.expressions.get(i);
            if (!expression.isWildcard()) continue;
            String string = expression.getSchemaName();
            String string2 = expression.getTableAlias();
            if (string2 == null) {
                int n = i;
                this.expressions.remove(i);
                for (TableFilter tableFilter : this.filters) {
                    object = new Wildcard(tableFilter.getTable().getSchema().getName(), tableFilter.getTableAlias());
                    this.expressions.add(i++, (Expression)object);
                }
                i = n - 1;
                continue;
            }
            TableFilter object3 = null;
            for (TableFilter tableFilter : this.filters) {
                if (!string2.equals(tableFilter.getTableAlias()) || string != null && !string.equals(tableFilter.getSchemaName())) continue;
                object3 = tableFilter;
                break;
            }
            if (object3 == null) {
                throw Message.getSQLException(42102, string2);
            }
            Table table = object3.getTable();
            String string3 = object3.getTableAlias();
            this.expressions.remove(i);
            for (Column column : object = table.getColumns()) {
                if (object3.isNaturalJoinColumn(column)) continue;
                ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), null, string3, column.getName());
                this.expressions.add(i++, expressionColumn);
            }
            --i;
        }
    }

    @Override
    public void init() throws SQLException {
        String string;
        Expression expression;
        int n;
        ObjectArray<String> objectArray;
        if (SysProperties.CHECK && this.checkInit) {
            Message.throwInternalError();
        }
        this.expandColumnList();
        this.visibleColumnCount = this.expressions.size();
        if (this.orderList != null || this.group != null) {
            objectArray = ObjectArray.newInstance();
            for (n = 0; n < this.visibleColumnCount; ++n) {
                expression = this.expressions.get(n);
                expression = expression.getNonAliasExpression();
                string = expression.getSQL();
                objectArray.add(string);
            }
        } else {
            objectArray = null;
        }
        if (this.orderList != null) {
            this.initOrder(this.expressions, objectArray, this.orderList, this.visibleColumnCount, this.distinct);
        }
        this.distinctColumnCount = this.expressions.size();
        if (this.having != null) {
            this.expressions.add(this.having);
            this.havingIndex = this.expressions.size() - 1;
            this.having = null;
        } else {
            this.havingIndex = -1;
        }
        if (this.group != null) {
            this.groupIndex = new int[this.group.size()];
            for (n = 0; n < this.group.size(); ++n) {
                Object object;
                int n2;
                expression = this.group.get(n);
                string = expression.getSQL();
                int n3 = -1;
                for (n2 = 0; n2 < objectArray.size(); ++n2) {
                    object = objectArray.get(n2);
                    if (!((String)object).equals(string)) continue;
                    n3 = n2;
                    break;
                }
                if (n3 < 0) {
                    for (n2 = 0; n2 < objectArray.size(); ++n2) {
                        object = this.expressions.get(n2);
                        if (!string.equals(((Expression)object).getAlias())) continue;
                        n3 = n2;
                        break;
                    }
                }
                if (n3 < 0) {
                    this.groupIndex[n] = n2 = this.expressions.size();
                    this.expressions.add(expression);
                    continue;
                }
                this.groupIndex[n] = n3;
            }
            this.groupByExpression = new boolean[this.expressions.size()];
            for (int n3 : this.groupIndex) {
                this.groupByExpression[n3] = true;
            }
            this.group = null;
        }
        for (TableFilter tableFilter : this.filters) {
            for (Expression expression2 : this.expressions) {
                expression2.mapColumns(tableFilter, 0);
            }
            if (this.condition == null) continue;
            this.condition.mapColumns(tableFilter, 0);
        }
        if (this.havingIndex >= 0) {
            Expression expression3 = this.expressions.get(this.havingIndex);
            SelectListColumnResolver selectListColumnResolver = new SelectListColumnResolver(this);
            expression3.mapColumns(selectListColumnResolver, 0);
        }
        this.checkInit = true;
    }

    @Override
    public void prepare() throws SQLException {
        if (this.isPrepared) {
            return;
        }
        if (SysProperties.CHECK && !this.checkInit) {
            Message.throwInternalError("not initialized");
        }
        if (this.orderList != null) {
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression object2 = this.expressions.get(i);
            this.expressions.set(i, object2.optimize(this.session));
        }
        if (this.condition != null) {
            this.condition = this.condition.optimize(this.session);
            if (SysProperties.optimizeInJoin) {
                this.condition = this.condition.optimizeInJoin(this.session, this);
            }
            for (TableFilter tableFilter : this.filters) {
                this.condition.createIndexConditions(this.session, tableFilter);
            }
        }
        if (this.isGroupQuery && this.groupIndex == null && this.havingIndex < 0 && this.filters.size() == 1 && this.condition == null) {
            ExpressionVisitor expressionVisitor = ExpressionVisitor.get(1);
            expressionVisitor.setTable(this.filters.get(0).getTable());
            this.isQuickAggregateQuery = this.isEverything(expressionVisitor);
        }
        this.cost = this.preparePlan();
        if (SysProperties.OPTIMIZE_DISTINCT && this.distinct && !this.isGroupQuery && this.filters.size() == 1 && this.expressions.size() == 1 && this.condition == null) {
            Expression expression = this.expressions.get(0);
            if ((expression = expression.getNonAliasExpression()) instanceof ExpressionColumn) {
                Column column = ((ExpressionColumn)expression).getColumn();
                int n = column.getSelectivity();
                Index index = this.topTableFilter.getTable().getIndexForColumn(column, true);
                if (index != null && n != 50 && n < 20) {
                    IndexType indexType;
                    boolean bl = index.getIndexColumns()[0].sortType == 0;
                    Index index2 = this.topTableFilter.getIndex();
                    if (!(!index.canFindNext() || !bl || index2 != null && !index2.getIndexType().isScan() && index != index2 || (indexType = index.getIndexType()).isHash() || indexType.isUnique() && index.getColumns().length <= 1)) {
                        this.topTableFilter.setIndex(index);
                        this.isDistinctQuery = true;
                    }
                }
            }
        }
        if (this.sort != null && !this.isQuickAggregateQuery && !this.isGroupQuery) {
            Index index = this.getSortIndex();
            Index index3 = this.topTableFilter.getIndex();
            if (index != null && (index3.getIndexType().isScan() || index3 == index)) {
                this.topTableFilter.setIndex(index);
                if (!(this.distinct && !this.isDistinctQuery || this.topTableFilter.hasInComparisons())) {
                    this.sortUsingIndex = true;
                }
            }
        }
        if (SysProperties.OPTIMIZE_GROUP_SORTED && !this.isQuickAggregateQuery && this.isGroupQuery && this.getGroupByExpressionCount() > 0) {
            Index index = this.getGroupSortedIndex();
            Index index4 = this.topTableFilter.getIndex();
            if (index != null && (index4.getIndexType().isScan() || index4 == index)) {
                this.topTableFilter.setIndex(index);
                this.isGroupSortedQuery = true;
            }
        }
        this.isPrepared = true;
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> hashSet = New.hashSet();
        for (TableFilter tableFilter : this.filters) {
            hashSet.add(tableFilter.getTable());
        }
        return hashSet;
    }

    @Override
    public void fireBeforeSelectTriggers() throws SQLException {
        for (TableFilter tableFilter : this.filters) {
            tableFilter.getTable().fire(this.session, 8, true);
        }
    }

    private double preparePlan() throws SQLException {
        TableFilter[] tableFilterArray = this.topFilters.toArray((TableFilter[])new TableFilter[this.topFilters.size()]);
        for (TableFilter tableFilter : tableFilterArray) {
            tableFilter.setFullCondition(this.condition);
        }
        Optimizer optimizer = new Optimizer(tableFilterArray, this.condition, this.session);
        optimizer.optimize();
        this.topTableFilter = optimizer.getTopFilter();
        double d = optimizer.getCost();
        for (TableFilter tableFilter = this.topTableFilter; tableFilter != null; tableFilter = tableFilter.getJoin()) {
            Expression expression;
            tableFilter.setEvaluatable(tableFilter, true);
            if (this.condition != null) {
                this.condition.setEvaluatable(tableFilter, true);
            }
            if ((expression = tableFilter.getJoinCondition()) != null && !expression.isEverything(3)) {
                if (tableFilter.isJoinOuter()) {
                    expression = expression.optimize(this.session);
                    throw Message.getSQLException(90136, expression.getSQL());
                }
                tableFilter.removeJoinCondition();
                expression = expression.optimize(this.session);
                this.addCondition(expression);
            }
            if ((expression = tableFilter.getFilterCondition()) != null && !expression.isEverything(3)) {
                tableFilter.removeFilterCondition();
                this.addCondition(expression);
            }
            for (Expression expression2 : this.expressions) {
                expression2.setEvaluatable(tableFilter, true);
            }
        }
        this.topTableFilter.prepare();
        return d;
    }

    @Override
    public String getPlanSQL() {
        int n;
        Expression[] expressionArray = this.expressions.toArray((Expression[])new Expression[this.expressions.size()]);
        StatementBuilder statementBuilder = new StatementBuilder("SELECT ");
        if (this.distinct) {
            statementBuilder.append("DISTINCT ");
        }
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expressionArray[i].getSQL());
        }
        statementBuilder.append("\nFROM ");
        TableFilter tableFilter = this.topTableFilter;
        if (tableFilter != null) {
            statementBuilder.resetCount();
            n = 0;
            do {
                statementBuilder.appendExceptFirst("\n");
                statementBuilder.append(tableFilter.getPlanSQL(n++ > 0));
            } while ((tableFilter = tableFilter.getJoin()) != null);
        } else {
            statementBuilder.resetCount();
            n = 0;
            for (TableFilter tableFilter2 : this.filters) {
                statementBuilder.appendExceptFirst("\n");
                statementBuilder.append(tableFilter2.getPlanSQL(n++ > 0));
            }
        }
        if (this.condition != null) {
            statementBuilder.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.groupIndex != null) {
            statementBuilder.append("\nGROUP BY ");
            statementBuilder.resetCount();
            for (int n2 : this.groupIndex) {
                Expression expression = expressionArray[n2];
                expression = expression.getNonAliasExpression();
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(StringUtils.unEnclose(expression.getSQL()));
            }
        }
        if (this.group != null) {
            statementBuilder.append("\nGROUP BY ");
            statementBuilder.resetCount();
            for (Expression expression : this.group) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(StringUtils.unEnclose(expression.getSQL()));
            }
        }
        if (this.having != null) {
            Expression expression = this.having;
            statementBuilder.append("\nHAVING ").append(StringUtils.unEnclose(expression.getSQL()));
        } else if (this.havingIndex >= 0) {
            Expression expression = expressionArray[this.havingIndex];
            statementBuilder.append("\nHAVING ").append(StringUtils.unEnclose(expression.getSQL()));
        }
        if (this.sort != null) {
            statementBuilder.append("\nORDER BY ").append(this.sort.getSQL(expressionArray, this.visibleColumnCount));
        }
        if (this.orderList != null) {
            statementBuilder.append("\nORDER BY ");
            statementBuilder.resetCount();
            for (SelectOrderBy selectOrderBy : this.orderList) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(StringUtils.unEnclose(selectOrderBy.getSQL()));
            }
        }
        if (this.limitExpr != null) {
            statementBuilder.append("\nLIMIT ").append(StringUtils.unEnclose(this.limitExpr.getSQL()));
            if (this.offsetExpr != null) {
                statementBuilder.append(" OFFSET ").append(StringUtils.unEnclose(this.offsetExpr.getSQL()));
            }
        }
        if (this.isForUpdate) {
            statementBuilder.append("\nFOR UPDATE");
        }
        if (this.isQuickAggregateQuery) {
            statementBuilder.append("\n/* direct lookup */");
        }
        if (this.isDistinctQuery) {
            statementBuilder.append("\n/* distinct */");
        }
        if (this.sortUsingIndex) {
            statementBuilder.append("\n/* index sorted */");
        }
        if (this.isGroupQuery && this.isGroupSortedQuery) {
            statementBuilder.append("\n/* group sorted */");
        }
        return statementBuilder.toString();
    }

    @Override
    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public TableFilter getTopTableFilter() {
        return this.topTableFilter;
    }

    @Override
    public ObjectArray<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void setForUpdate(boolean bl) {
        this.isForUpdate = bl;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        for (Expression expression : this.expressions) {
            expression.mapColumns(columnResolver, n);
        }
        if (this.condition != null) {
            this.condition.mapColumns(columnResolver, n);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.expressions) {
            expression.setEvaluatable(tableFilter, bl);
        }
        if (this.condition != null) {
            this.condition.setEvaluatable(tableFilter, bl);
        }
    }

    public boolean isQuickAggregateQuery() {
        return this.isQuickAggregateQuery;
    }

    @Override
    public void addGlobalCondition(Parameter parameter, int n, int n2) throws SQLException {
        this.addParameter(parameter);
        Expression expression = this.expressions.get(n);
        expression = expression.getNonAliasExpression();
        Expression expression2 = new Comparison(this.session, n2, expression, parameter);
        expression2 = ((Expression)expression2).optimize(this.session);
        boolean bl = true;
        if (this.isGroupQuery) {
            bl = false;
            for (int i = 0; this.groupIndex != null && i < this.groupIndex.length; ++i) {
                if (this.groupIndex[i] != n) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (this.havingIndex >= 0) {
                    this.having = this.expressions.get(this.havingIndex);
                }
                this.having = this.having == null ? expression2 : new ConditionAndOr(0, this.having, expression2);
            }
        }
        if (bl) {
            this.condition = this.condition == null ? expression2 : new ConditionAndOr(0, this.condition, expression2);
        }
    }

    @Override
    public void updateAggregate(Session session) throws SQLException {
        for (Expression expression : this.expressions) {
            expression.updateAggregate(session);
        }
        if (this.condition != null) {
            this.condition.updateAggregate(session);
        }
        if (this.having != null) {
            this.having.updateAggregate(session);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 2: {
                for (TableFilter object : this.filters) {
                    if (object.getTable().isDeterministic()) continue;
                    return false;
                }
                break;
            }
            case 4: {
                for (TableFilter tableFilter : this.filters) {
                    long l = tableFilter.getTable().getMaxDataModificationId();
                    expressionVisitor.addDataModificationId(l);
                }
                break;
            }
            case 3: {
                if (SysProperties.OPTIMIZE_EVALUATABLE_SUBQUERIES) break;
                return false;
            }
            case 7: {
                for (TableFilter tableFilter : this.filters) {
                    Table table = tableFilter.getTable();
                    expressionVisitor.addDependency(table);
                    table.addDependencies(expressionVisitor.getDependencies());
                }
                break;
            }
        }
        expressionVisitor.incrementQueryLevel(1);
        boolean bl = true;
        for (Expression expression : this.expressions) {
            if (expression.isEverything(expressionVisitor)) continue;
            bl = false;
            break;
        }
        if (bl && this.condition != null && !this.condition.isEverything(expressionVisitor)) {
            bl = false;
        }
        if (bl && this.having != null && !this.having.isEverything(expressionVisitor)) {
            bl = false;
        }
        expressionVisitor.incrementQueryLevel(-1);
        return bl;
    }

    @Override
    public boolean isReadOnly() {
        return this.isEverything(5);
    }

    @Override
    public String getFirstColumnAlias(Session session) {
        Expression expression;
        if (SysProperties.CHECK && this.visibleColumnCount > 1) {
            Message.throwInternalError("" + this.visibleColumnCount);
        }
        if ((expression = this.expressions.get(0)) instanceof Alias) {
            return expression.getAlias();
        }
        Mode mode = session.getDatabase().getMode();
        String string = session.getNextSystemIdentifier(this.getSQL());
        expression = new Alias(expression, string, mode.aliasColumnName);
        this.expressions.set(0, expression);
        return expression.getAlias();
    }
}

