/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.thread;

import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.utils.ThreadUtil;
import com.arjuna.ats.internal.arjuna.thread.ThreadSetup;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import java.util.Stack;

public class ThreadActionData {
    private static ThreadLocal _threadList = new ThreadLocal();
    private static ArrayList _threadSetups = new ArrayList();

    public static BasicAction currentAction() {
        ThreadActionData.setup();
        Stack txs = (Stack)_threadList.get();
        if (txs != null) {
            try {
                return (BasicAction)txs.peek();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void pushAction(BasicAction a) {
        ThreadActionData.pushAction(a, true);
    }

    public static void pushAction(BasicAction a, boolean register) {
        Thread t = Thread.currentThread();
        Stack<BasicAction> txs = (Stack<BasicAction>)_threadList.get();
        if (txs == null) {
            txs = new Stack<BasicAction>();
            txs.push(a);
            _threadList.set(txs);
        } else {
            txs.push(a);
        }
        if (register) {
            a.addChildThread(t);
        }
    }

    public static void restoreActions(BasicAction act) {
        ThreadActionData.purgeActions();
        if (act != null) {
            Stack<BasicAction> s = new Stack<BasicAction>();
            s.push(act);
            for (BasicAction nextLevel = act.parent(); nextLevel != null; nextLevel = nextLevel.parent()) {
                s.push(nextLevel);
            }
            try {
                while (!s.empty()) {
                    ThreadActionData.pushAction((BasicAction)s.pop());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static BasicAction popAction() throws EmptyStackException {
        return ThreadActionData.popAction(ThreadUtil.getThreadId(), true);
    }

    public static BasicAction popAction(boolean unregister) throws EmptyStackException {
        return ThreadActionData.popAction(ThreadUtil.getThreadId(), unregister);
    }

    public static BasicAction popAction(String threadId) throws EmptyStackException {
        return ThreadActionData.popAction(threadId, true);
    }

    public static BasicAction popAction(String threadId, boolean unregister) throws EmptyStackException {
        Stack txs = (Stack)_threadList.get();
        if (txs != null) {
            BasicAction a = (BasicAction)txs.pop();
            if (a != null && unregister) {
                a.removeChildThread(threadId);
            }
            if (txs.size() == 0) {
                _threadList.set(null);
            }
            return a;
        }
        return null;
    }

    public static void purgeAction(BasicAction act) throws NoSuchElementException {
        ThreadActionData.purgeAction(act, Thread.currentThread(), true);
    }

    public static void purgeAction(BasicAction act, Thread t) throws NoSuchElementException {
        ThreadActionData.purgeAction(act, t, true);
    }

    public static void purgeAction(BasicAction act, Thread t, boolean unregister) throws NoSuchElementException {
        Stack txs;
        if (act != null && unregister) {
            act.removeChildThread(ThreadUtil.getThreadId(t));
        }
        if ((txs = (Stack)_threadList.get()) != null) {
            txs.removeElement(act);
            if (txs.size() == 0) {
                _threadList.set(null);
            }
        }
    }

    public static void purgeActions() {
        ThreadActionData.purgeActions(Thread.currentThread(), true);
    }

    public static void purgeActions(Thread t) {
        ThreadActionData.purgeActions(t, true);
    }

    public static void purgeActions(Thread t, boolean unregister) {
        Stack txs = (Stack)_threadList.get();
        _threadList.set(null);
        if (txs != null && unregister) {
            while (!txs.empty()) {
                BasicAction act = (BasicAction)txs.pop();
                if (act == null) continue;
                act.removeChildThread(ThreadUtil.getThreadId(t));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSetup(ThreadSetup s) {
        ArrayList arrayList = _threadSetups;
        synchronized (arrayList) {
            _threadSetups.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeSetup(ThreadSetup s) {
        ArrayList arrayList = _threadSetups;
        synchronized (arrayList) {
            return _threadSetups.remove(s);
        }
    }

    private static void setup() {
        for (int i = 0; i < _threadSetups.size(); ++i) {
            ThreadSetup s = (ThreadSetup)_threadSetups.get(i);
            if (s == null) continue;
            s.setup();
        }
    }
}

