/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.solr.search.function.DocValues;

class ValueSourceScorer
extends Scorer {
    protected IndexReader reader;
    private int doc = -1;
    protected final int maxDoc;
    protected final DocValues values;
    protected boolean checkDeletes;

    protected ValueSourceScorer(IndexReader reader, DocValues values) {
        super(null);
        this.reader = reader;
        this.maxDoc = reader.maxDoc();
        this.values = values;
        this.setCheckDeletes(true);
    }

    public IndexReader getReader() {
        return this.reader;
    }

    public void setCheckDeletes(boolean checkDeletes) {
        this.checkDeletes = checkDeletes && this.reader.hasDeletions();
    }

    public boolean matches(int doc) {
        return (!this.checkDeletes || !this.reader.isDeleted(doc)) && this.matchesValue(doc);
    }

    public boolean matchesValue(int doc) {
        return true;
    }

    public int docID() {
        return this.doc;
    }

    public int nextDoc() throws IOException {
        do {
            ++this.doc;
            if (this.doc < this.maxDoc) continue;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        } while (!this.matches(this.doc));
        return this.doc;
    }

    public int advance(int target) throws IOException {
        this.doc = target - 1;
        return this.nextDoc();
    }

    public int doc() {
        return this.doc;
    }

    public boolean next() {
        do {
            ++this.doc;
            if (this.doc < this.maxDoc) continue;
            return false;
        } while (!this.matches(this.doc));
        return true;
    }

    public boolean skipTo(int target) {
        this.doc = target - 1;
        return this.next();
    }

    public float score() throws IOException {
        return this.values.floatVal(this.doc);
    }

    public Explanation explain(int doc) throws IOException {
        return this.values.explain(doc);
    }
}

