/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;

public final class SavedNamespaceContext
implements Serializable,
NamespaceResolver {
    private int[] namespaceCodes;
    private NamePool namePool;

    public SavedNamespaceContext(int[] nArray, NamePool namePool) {
        this.namespaceCodes = nArray;
        this.namePool = namePool;
    }

    public int[] getNamespaceCodes() {
        return this.namespaceCodes;
    }

    public String getURIForPrefix(String string, boolean bl) {
        if (string.equals("") && !bl) {
            return "";
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i = this.namespaceCodes.length - 1; i >= 0; --i) {
            if (!this.namePool.getPrefixFromNamespaceCode(this.namespaceCodes[i]).equals(string)) continue;
            return this.namePool.getURIFromNamespaceCode(this.namespaceCodes[i]);
        }
        if (string.equals("") && bl) {
            return "";
        }
        return null;
    }

    public Iterator iteratePrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.namespaceCodes.length);
        for (int i = 0; i < this.namespaceCodes.length; ++i) {
            arrayList.add(this.namePool.getPrefixFromNamespaceCode(this.namespaceCodes[i]));
        }
        return arrayList.iterator();
    }
}

