/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf.transports;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.perf.Configuration;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.Util;

public class TcpTransport
implements Transport {
    Receiver receiver = null;
    Properties config = null;
    Configuration cfg = null;
    int max_receiver_buffer_size = 500000;
    int max_send_buffer_size = 500000;
    List nodes;
    ConnectionTable ct;
    int start_port = 7800;
    ServerSocket srv_sock = null;
    InetAddress bind_addr = null;
    IpAddress local_addr = null;
    List receivers = new ArrayList();

    @Override
    public Object getLocalAddress() {
        return this.local_addr;
    }

    @Override
    public String help() {
        return "[-cluster <list of address:port pairs>]";
    }

    @Override
    public void create(Properties properties) throws Exception {
        this.config = properties;
        String tmp = this.config.getProperty("srv_port");
        if (tmp != null) {
            this.start_port = Integer.parseInt(tmp);
        } else {
            tmp = this.config.getProperty("start_port");
            if (tmp != null) {
                this.start_port = Integer.parseInt(tmp);
            }
        }
        this.bind_addr = Util.getBindAddress(this.config);
        String cluster_def = this.config.getProperty("cluster");
        if (cluster_def == null) {
            throw new Exception("TcpTransport.create(): property 'cluster' is not defined");
        }
        this.nodes = TcpTransport.parseCommaDelimitedList(cluster_def);
        this.ct = new ConnectionTable(this.nodes);
    }

    @Override
    public void create(Configuration config) throws Exception {
        this.cfg = config;
        String[] args = config.getTransportArgs();
        if (args != null) {
            // empty if block
        }
    }

    @Override
    public void start() throws Exception {
        this.srv_sock = Util.createServerSocket(new DefaultSocketFactory(), "jgroups.tests.perf.TcpTransport.srv_sock", this.bind_addr, this.start_port);
        this.local_addr = new IpAddress(this.srv_sock.getInetAddress(), this.srv_sock.getLocalPort());
        System.out.println("-- local address is " + this.local_addr);
        this.ct.init();
        Thread acceptor = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Socket s = TcpTransport.this.srv_sock.accept();
                        ReceiverThread r = new ReceiverThread(s);
                        r.setDaemon(true);
                        TcpTransport.this.receivers.add(r);
                        r.start();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
        };
        acceptor.setDaemon(true);
        acceptor.start();
    }

    @Override
    public void stop() {
        this.ct.close();
        for (ReceiverThread thread : this.receivers) {
            thread.stopThread();
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    @Override
    public Map dumpStats() {
        return null;
    }

    @Override
    public void send(Object destination, byte[] payload, boolean oob) throws Exception {
        if (destination != null) {
            throw new Exception("TcpTransport.send(): unicasts not supported");
        }
        this.ct.writeMessage(payload);
    }

    public static List parseCommaDelimitedList(String s) throws Exception {
        ArrayList<InetSocketAddress> retval = new ArrayList<InetSocketAddress>();
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            String tmp = tok.nextToken();
            int index = tmp.indexOf(58);
            if (index == -1) {
                throw new Exception("host must be in format <host:port>, was " + tmp);
            }
            String hostname = tmp.substring(0, index);
            int port = Integer.parseInt(tmp.substring(index + 1));
            InetSocketAddress addr = new InetSocketAddress(hostname, port);
            retval.add(addr);
        }
        return retval;
    }

    class ReceiverThread
    extends Thread {
        Socket sock;
        DataInputStream in;
        Address peer_addr;

        ReceiverThread(Socket sock) throws Exception {
            this.sock = sock;
            this.in = new DataInputStream(new BufferedInputStream(sock.getInputStream()));
            this.peer_addr = Util.readAddress(this.in);
        }

        @Override
        public void run() {
            while (this.sock != null) {
                try {
                    int len = this.in.readInt();
                    byte[] buf = new byte[len];
                    this.in.readFully(buf, 0, len);
                    if (TcpTransport.this.receiver == null) continue;
                    TcpTransport.this.receiver.receive(this.peer_addr, buf);
                }
                catch (EOFException eof) {
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                    break;
                }
            }
            System.out.println("-- receiver thread for " + this.peer_addr + " terminated");
        }

        void stopThread() {
            try {
                this.sock.close();
                this.sock = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Connection {
        Socket sock = null;
        DataOutputStream out;
        InetSocketAddress to;
        final Object mutex = new Object();

        Connection(InetSocketAddress addr) {
            this.to = addr;
        }

        void createSocket() throws IOException {
            this.sock = new Socket(this.to.getAddress(), this.to.getPort());
            this.sock.setSendBufferSize(TcpTransport.this.max_send_buffer_size);
            this.sock.setReceiveBufferSize(TcpTransport.this.max_receiver_buffer_size);
            this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            Util.writeAddress(TcpTransport.this.local_addr, this.out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeMessage(byte[] msg) throws Exception {
            Object object = this.mutex;
            synchronized (object) {
                if (this.sock == null) {
                    this.createSocket();
                }
                this.out.writeInt(msg.length);
                this.out.write(msg, 0, msg.length);
            }
            this.out.flush();
        }

        void close() {
            try {
                this.out.flush();
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return "Connection from " + TcpTransport.this.local_addr + " to " + this.to;
        }
    }

    class ConnectionTable {
        List myNodes;
        final Connection[] connections;

        ConnectionTable(List nodes) throws Exception {
            this.myNodes = nodes;
            this.connections = new Connection[nodes.size()];
        }

        void init() throws Exception {
            int i = 0;
            for (InetSocketAddress addr : this.myNodes) {
                if (this.connections[i] == null) {
                    try {
                        this.connections[i] = new Connection(addr);
                        this.connections[i].createSocket();
                        System.out.println("-- connected to " + addr);
                    }
                    catch (ConnectException connect_ex) {
                        System.out.println("-- failed to connect to " + addr);
                    }
                }
                ++i;
            }
        }

        void writeMessage(byte[] msg) throws Exception {
            for (int i = 0; i < this.connections.length; ++i) {
                Connection c = this.connections[i];
                if (c == null) continue;
                try {
                    c.writeMessage(msg);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        void close() {
            for (int i = 0; i < this.connections.length; ++i) {
                Connection c = this.connections[i];
                if (c == null) continue;
                c.close();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator it = this.myNodes.iterator();
            while (it.hasNext()) {
                sb.append(it.next()).append(' ');
            }
            return sb.toString();
        }
    }
}

