/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;

public class LargeStateClient {
    Socket sock;
    InetAddress bind_addr;
    InetAddress host_addr;
    boolean looping = true;

    private void start(String bind_addr, String host_addr, int chunk) throws Exception {
        this.bind_addr = InetAddress.getByName(bind_addr);
        this.host_addr = InetAddress.getByName(host_addr);
        this.sock = new Socket(this.host_addr, 7500, this.bind_addr, 0);
        this.sock.setReceiveBufferSize(chunk);
        this.readLargeState(this.sock);
        this.sock.close();
    }

    private void readLargeState(Socket sock) throws IOException {
        int num;
        InputStream in = sock.getInputStream();
        long total = 0L;
        long start = 0L;
        byte[] buf = new byte[sock.getReceiveBufferSize()];
        start = System.currentTimeMillis();
        while (this.looping && (num = in.read(buf, 0, buf.length)) != -1) {
            if ((total += (long)num) % 100000000L != 0L) continue;
            System.out.println("-- read " + total / 1000000L + " MB");
        }
        long stop = System.currentTimeMillis();
        System.out.println("- done, read " + total / 1000000L + " MB in " + (stop - start) + "ms (" + (double)(total / 1000000L) / ((double)(stop - start) / 1000.0) + " MB/sec");
    }

    public static void main(String[] args) throws Exception {
        String bind_addr = null;
        String host = "localhost";
        int chunk = 10000;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-bind_addr")) {
                bind_addr = args[++i];
                continue;
            }
            if (args[i].equals("-host")) {
                host = args[++i];
                continue;
            }
            if (args[i].equals("-chunk")) {
                chunk = Integer.parseInt(args[++i]);
                continue;
            }
            System.out.println("LargeStateServer [-bind_addr <addr>] [-host <host address>][-chunk <chunk size (bytes)>]");
            return;
        }
        new LargeStateClient().start(bind_addr, host, chunk);
    }
}

