/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.search;

import com.jurismarches.vradi.services.search.CompareFilter;
import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import com.jurismarches.vradi.services.search.VradiQueryParser;
import org.junit.Assert;
import org.junit.Test;

public class VradiQueryParserTest {
    @Test
    public void testQueryParse() throws UnsupportedQueryException {
        String query1 = "thesaurus:toto AND NOT (acheteur:titi OR acheteur:tata)";
        FilterList filterList = VradiQueryParser.parse((String)query1);
        Assert.assertEquals((long)1L, (long)filterList.getFilters().size());
        String query2 = "toto AND NOT (acheteur:titi OR acheteur:tata)";
        filterList = VradiQueryParser.parse((String)query2);
        Assert.assertEquals((long)1L, (long)filterList.getFilters().size());
        String query3 = "text:toto AND NOT (acheteur:titi OR acheteur:tata)";
        filterList = VradiQueryParser.parse((String)query3);
        Assert.assertEquals((long)1L, (long)filterList.getFilters().size());
        String query4 = "toto AND NOT (acheteur:titi OR acheteur:tata)";
        filterList = VradiQueryParser.parse((String)query4, (String)"anotherfield");
        Assert.assertEquals((long)1L, (long)filterList.getFilters().size());
        String query5 = "object:\"tata titi toto\"";
        filterList = VradiQueryParser.parse((String)query5);
        Assert.assertEquals((long)1L, (long)filterList.getFilters().size());
        CompareFilter f = (CompareFilter)filterList.getFilters().get(0);
        Assert.assertEquals((Object)"tata titi toto", (Object)f.getValue());
    }

    @Test(expected=UnsupportedQueryException.class)
    public void testQueryParseException() throws UnsupportedQueryException {
        String query1 = "AND OR NOT";
        VradiQueryParser.parse((String)query1);
    }
}

