/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiServiceConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VradiTestConfiguration
extends VradiServiceConfiguration {
    private static final Log log = LogFactory.getLog(VradiTestConfiguration.class);

    public static synchronized VradiServiceConfiguration getInstance() {
        if (instance == null) {
            try {
                instance = new VradiTestConfiguration();
                instance = VradiTestConfiguration.loadOptionConfigurationTest(instance);
                instance.setSystemDefaultProps();
            }
            catch (Exception e) {
                throw new UnhandledException((Throwable)e);
            }
        }
        return instance;
    }

    protected static VradiServiceConfiguration loadOptionConfigurationTest(VradiServiceConfiguration configuration) throws IOException {
        InputStream input = VradiServiceConfiguration.class.getResourceAsStream("/vradi-services.properties");
        Properties options = new Properties();
        options.load(input);
        configuration.setOptions(options);
        configuration.setOption("vradi.data.dir", "target" + File.separator + "vradi");
        configuration.setWikittyListenEvents(false);
        configuration.setServiceVersion(configuration.getApplicationVersion());
        configuration.setLocale(Locale.FRANCE);
        if (log.isInfoEnabled()) {
            log.info((Object)("Using test configuration : " + configuration.getFlatOptions()));
        }
        return configuration;
    }
}

