/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResponse
extends SolrResponseBase {
    private NamedList<Object> _header = null;
    private SolrDocumentList _results = null;
    private NamedList<ArrayList> _sortvalues = null;
    private NamedList<Object> _facetInfo = null;
    private NamedList<Object> _debugInfo = null;
    private NamedList<Object> _highlightingInfo = null;
    private NamedList<Object> _spellInfo = null;
    private NamedList<Object> _statsInfo = null;
    private Map<String, Integer> _facetQuery = null;
    private List<FacetField> _facetFields = null;
    private List<FacetField> _limitingFacets = null;
    private List<FacetField> _facetDates = null;
    private Map<String, Map<String, List<String>>> _highlighting = null;
    private SpellCheckResponse _spellResponse = null;
    private Map<String, FieldStatsInfo> _fieldStatsInfo = null;
    private Map<String, Object> _debugMap = null;
    private Map<String, String> _explainMap = null;
    private final transient SolrServer solrServer;

    public QueryResponse() {
        this.solrServer = null;
    }

    public QueryResponse(NamedList<Object> res, SolrServer solrServer) {
        this.setResponse(res);
        this.solrServer = solrServer;
    }

    @Override
    public void setResponse(NamedList<Object> res) {
        super.setResponse(res);
        for (int i = 0; i < res.size(); ++i) {
            String n = res.getName(i);
            if ("responseHeader".equals(n)) {
                this._header = (NamedList)res.getVal(i);
                continue;
            }
            if ("response".equals(n)) {
                this._results = (SolrDocumentList)res.getVal(i);
                continue;
            }
            if ("sort_values".equals(n)) {
                this._sortvalues = (NamedList)res.getVal(i);
                continue;
            }
            if ("facet_counts".equals(n)) {
                this._facetInfo = (NamedList)res.getVal(i);
                this.extractFacetInfo(this._facetInfo);
                continue;
            }
            if ("debug".equals(n)) {
                this._debugInfo = (NamedList)res.getVal(i);
                this.extractDebugInfo(this._debugInfo);
                continue;
            }
            if ("highlighting".equals(n)) {
                this._highlightingInfo = (NamedList)res.getVal(i);
                this.extractHighlightingInfo(this._highlightingInfo);
                continue;
            }
            if ("spellcheck".equals(n)) {
                this._spellInfo = (NamedList)res.getVal(i);
                this.extractSpellCheckInfo(this._spellInfo);
                continue;
            }
            if (!"stats".equals(n)) continue;
            this._statsInfo = (NamedList)res.getVal(i);
            this.extractStatsInfo(this._statsInfo);
        }
    }

    private void extractSpellCheckInfo(NamedList<Object> spellInfo) {
        this._spellResponse = new SpellCheckResponse(spellInfo);
    }

    private void extractStatsInfo(NamedList<Object> info) {
        if (info != null) {
            this._fieldStatsInfo = new HashMap<String, FieldStatsInfo>();
            NamedList ff = (NamedList)info.get("stats_fields");
            if (ff != null) {
                for (Map.Entry entry : ff) {
                    NamedList v = (NamedList)entry.getValue();
                    if (v == null) continue;
                    this._fieldStatsInfo.put(entry.getKey(), new FieldStatsInfo(v, entry.getKey()));
                }
            }
        }
    }

    private void extractDebugInfo(NamedList<Object> debug) {
        this._debugMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : debug) {
            this._debugMap.put(entry.getKey(), entry.getValue());
        }
        this._explainMap = new HashMap<String, String>();
        NamedList explain = (NamedList)this._debugMap.get("explain");
        if (explain != null) {
            for (Map.Entry info : explain) {
                String key = info.getKey();
                this._explainMap.put(key, (String)info.getValue());
            }
        }
    }

    private void extractHighlightingInfo(NamedList<Object> info) {
        this._highlighting = new HashMap<String, Map<String, List<String>>>();
        for (Map.Entry<String, Object> entry : info) {
            HashMap fieldMap = new HashMap();
            this._highlighting.put(entry.getKey(), fieldMap);
            NamedList fnl = (NamedList)entry.getValue();
            for (Map.Entry field : fnl) {
                fieldMap.put(field.getKey(), field.getValue());
            }
        }
    }

    private void extractFacetInfo(NamedList<Object> info) {
        NamedList df;
        NamedList ff;
        this._facetQuery = new HashMap<String, Integer>();
        NamedList fq = (NamedList)info.get("facet_queries");
        if (fq != null) {
            for (Map.Entry entry : fq) {
                this._facetQuery.put(entry.getKey(), (Integer)entry.getValue());
            }
        }
        if ((ff = (NamedList)info.get("facet_fields")) != null) {
            this._facetFields = new ArrayList<FacetField>(ff.size());
            this._limitingFacets = new ArrayList<FacetField>(ff.size());
            long minsize = this._results.getNumFound();
            for (Map.Entry facet : ff) {
                FacetField f = new FacetField(facet.getKey());
                for (Map.Entry entry : (NamedList)facet.getValue()) {
                    f.add(entry.getKey(), ((Number)entry.getValue()).longValue());
                }
                this._facetFields.add(f);
                FacetField nl = f.getLimitingFields(minsize);
                if (nl.getValueCount() <= 0) continue;
                this._limitingFacets.add(nl);
            }
        }
        if ((df = (NamedList)info.get("facet_dates")) != null) {
            this._facetDates = new ArrayList<FacetField>(df.size());
            for (Map.Entry facet : df) {
                NamedList values = (NamedList)facet.getValue();
                String gap = (String)values.get("gap");
                Date end = (Date)values.get("end");
                FacetField f = new FacetField(facet.getKey(), gap, end);
                for (Map.Entry entry : values) {
                    try {
                        f.add(entry.getKey(), Long.parseLong(entry.getValue().toString()));
                    }
                    catch (NumberFormatException e) {}
                }
                this._facetDates.add(f);
            }
        }
    }

    public void removeFacets() {
        this._facetFields = new ArrayList<FacetField>();
    }

    public NamedList<Object> getHeader() {
        return this._header;
    }

    public SolrDocumentList getResults() {
        return this._results;
    }

    public NamedList<ArrayList> getSortValues() {
        return this._sortvalues;
    }

    public Map<String, Object> getDebugMap() {
        return this._debugMap;
    }

    public Map<String, String> getExplainMap() {
        return this._explainMap;
    }

    public Map<String, Integer> getFacetQuery() {
        return this._facetQuery;
    }

    public Map<String, Map<String, List<String>>> getHighlighting() {
        return this._highlighting;
    }

    public SpellCheckResponse getSpellCheckResponse() {
        return this._spellResponse;
    }

    public List<FacetField> getFacetFields() {
        return this._facetFields;
    }

    public List<FacetField> getFacetDates() {
        return this._facetDates;
    }

    public FacetField getFacetField(String name) {
        if (this._facetFields == null) {
            return null;
        }
        for (FacetField f : this._facetFields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public FacetField getFacetDate(String name) {
        if (this._facetDates == null) {
            return null;
        }
        for (FacetField f : this._facetDates) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public List<FacetField> getLimitingFacets() {
        return this._limitingFacets;
    }

    public <T> List<T> getBeans(Class<T> type) {
        return this.solrServer == null ? new DocumentObjectBinder().getBeans(type, this._results) : this.solrServer.getBinder().getBeans(type, this._results);
    }

    public Map<String, FieldStatsInfo> getFieldStatsInfo() {
        return this._fieldStatsInfo;
    }
}

