/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiTestConfiguration;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryParameters;
import com.jurismarches.vradi.beans.XmlStreamImportResult;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.ClientImpl;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupImpl;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.ThesaurusImpl;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.UserImpl;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.entities.XmlStreamImpl;
import com.jurismarches.vradi.services.FileService;
import com.jurismarches.vradi.services.FileServiceImpl;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiDataServiceImpl;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.nuiton.util.Resource;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;

public abstract class VradiTestAbstract {
    private static final Log log = LogFactory.getLog(VradiTestAbstract.class);
    protected WikittyProxy wikittyProxy;
    protected VradiDataService dataService;
    protected VradiStorageService storageService;
    protected FileService fileService = null;

    @BeforeClass
    public static void initConfig() {
        VradiTestConfiguration.getInstance();
        String tmpdir = System.getProperty("java.io.tmpdir");
        File file = new File(tmpdir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating tmp dir : " + file));
        }
    }

    @Before
    public void clear() throws Exception {
        log.debug((Object)"--clear-----------------------------------------");
        this.storageService = ServiceFactory.getVradiStorageService();
        this.wikittyProxy = ServiceFactory.getWikittyProxy();
        this.wikittyProxy.clear();
        this.dataService = new VradiDataServiceImpl(this.wikittyProxy);
        this.fileService = new FileServiceImpl();
    }

    protected WikittyExtension createFileFormType() throws VradiException {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put("name", FieldTypeEnum.STRING.getFieldType());
        fields.put("dir", FieldTypeEnum.STRING.getFieldType());
        fields.put("size", FieldTypeEnum.NUMERIC.getFieldType());
        fields.put("lastModified", FieldTypeEnum.DATE_TIME.getFieldType());
        fields.put("modified", FieldTypeEnum.STRING.getFieldType());
        fields.put("description", FieldTypeEnum.TEXT.getFieldType());
        return this.createFormType("file", fields);
    }

    protected WikittyExtension createAnnonceFormType() throws VradiException {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put("acheteur", FieldTypeEnum.STRING.getFieldType());
        fields.put("date", FieldTypeEnum.STRING.getFieldType());
        fields.put("departement", FieldTypeEnum.STRING.getFieldType());
        fields.put("description", FieldTypeEnum.STRING.getFieldType());
        fields.put("intitule", FieldTypeEnum.STRING.getFieldType());
        return this.createFormType("annonce", fields);
    }

    protected WikittyExtension createDatesFormType() throws VradiException {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put("id", FieldTypeEnum.STRING.getFieldType());
        fields.put("date", FieldTypeEnum.DATE_TIME.getFieldType());
        return this.createFormType("dates", fields);
    }

    protected WikittyExtension createFormType(String name, Map<String, FieldType> fields) throws VradiException {
        WikittyExtension extension = this.dataService.getFormType(name);
        if (extension == null) {
            extension = this.dataService.updateFormType(name, fields, "Form", null);
        }
        return extension;
    }

    protected List<XmlFieldBinding> createXmlBindings(WikittyExtension extension) throws Exception {
        ArrayList<XmlFieldBinding> bindings = new ArrayList();
        String name = extension.getName();
        Collection fieldNames = extension.getFieldNames();
        for (String field : fieldNames) {
            XmlFieldBindingImpl binding = new XmlFieldBindingImpl();
            binding.setFormField(name + "." + field);
            binding.addXmlField(field);
            bindings.add((XmlFieldBinding)binding);
        }
        bindings = this.dataService.updateXmlFieldBindings(bindings);
        return bindings;
    }

    protected XmlStream createXmlStream(WikittyExtension extension, List<XmlFieldBinding> bindings, URL resource) throws Exception {
        XmlStreamImpl stream = new XmlStreamImpl();
        stream.setName(extension.getId());
        stream.setFormTypeName(extension.getName());
        log.info((Object)("Setting xmlStream url to: " + resource.toExternalForm()));
        stream.setUrl(resource.toExternalForm());
        for (XmlFieldBinding fieldBinding : bindings) {
            stream.addXmlFieldBinding(fieldBinding.getWikittyId());
        }
        BusinessEntity updateEntity = this.wikittyProxy.store((BusinessEntity)stream);
        return (XmlStream)updateEntity;
    }

    protected XmlStream createXmlStream(WikittyExtension extension, List<XmlFieldBinding> bindings) throws Exception {
        String url = "/" + extension.getName() + ".xml";
        URL resource = Resource.getURL((String)url);
        return this.createXmlStream(extension, bindings, resource);
    }

    protected Status createSatus(String name, String description, int value, boolean modifiable) throws Exception {
        StatusImpl status = new StatusImpl();
        status.setName(name);
        status.setDescription(description);
        status.setValue(value);
        status.setModifiable(modifiable);
        BusinessEntity updateEntity = this.wikittyProxy.store((BusinessEntity)status);
        return (Status)updateEntity;
    }

    protected Client createClient(String name, String ... queries) throws Exception {
        ClientImpl client = new ClientImpl();
        client.setName(name);
        client = (Client)this.wikittyProxy.store((BusinessEntity)client);
        return client;
    }

    protected User createUser(String name, String ... queries) throws Exception {
        UserImpl user = new UserImpl();
        user.setName(name);
        user = (User)this.wikittyProxy.store((BusinessEntity)user);
        return user;
    }

    protected Group createGroup(String name, String ... queries) throws Exception {
        GroupImpl group = new GroupImpl();
        for (String query : queries) {
            group.addQueries(query);
        }
        group.setName(name);
        group = (Group)this.wikittyProxy.store((BusinessEntity)group);
        return group;
    }

    protected WikittyExtension createThesaurusExtension() throws Exception {
        WikittyExtension thesaurusExtension = ThesaurusImpl.extensionThesaurus;
        thesaurusExtension = this.dataService.updateFormType(thesaurusExtension);
        return thesaurusExtension;
    }

    protected Thesaurus createThesaurus(String name, RootThesaurus rootThesaurus, String ... tags) throws Exception {
        return this.createThesaurus(name, null, rootThesaurus, tags);
    }

    protected Thesaurus createThesaurus(String name, String parent, RootThesaurus rootThesaurus, String ... tags) throws Exception {
        ThesaurusImpl result = new ThesaurusImpl();
        result.setName(name);
        result.setParent(parent);
        result.setRootThesaurus(rootThesaurus.getWikittyId());
        if (tags != null) {
            for (String tag : tags) {
                result.addTags(tag);
            }
        }
        result = (Thesaurus)this.wikittyProxy.store((BusinessEntity)result);
        return result;
    }

    protected void testSearch(String query, int count) throws Exception {
        FormPagedResult testSearch = this.testSearch(query);
        Assert.assertEquals((long)count, (long)testSearch.getTotalFoundFormNb());
    }

    protected FormPagedResult testSearch(String query) throws Exception {
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters(query);
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        if (log.isTraceEnabled()) {
            this.traceFormsFound(formPagedResult);
        }
        return formPagedResult;
    }

    protected void testSearch(Status[] statuses, int count) throws Exception {
        FormPagedResult testSearch = this.testSearch(statuses);
        Assert.assertEquals((long)count, (long)testSearch.getTotalFoundFormNb());
    }

    protected FormPagedResult testSearch(Status[] statuses) throws Exception {
        ArrayList<String> statusIds = null;
        if (statuses != null) {
            statusIds = new ArrayList<String>(statuses.length);
            for (int i = 0; i < statuses.length; ++i) {
                statusIds.add(statuses[i].getWikittyId());
            }
        }
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters();
        queryParameters.setStatusIds(statusIds);
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        if (log.isTraceEnabled()) {
            this.traceFormsFound(formPagedResult);
        }
        return formPagedResult;
    }

    protected void traceFormsFound(FormPagedResult formPageDTO) {
        List formsIds = formPageDTO.getFormsIdsToShow();
        List forms = this.wikittyProxy.restore(Form.class, formsIds);
        for (Form form : forms) {
            Collection extensions = form.getExtensionNames();
            log.trace((Object)form.getWikittyId());
            for (String extension : extensions) {
                Collection extensionFields = form.getExtensionFields(extension);
                for (String field : extensionFields) {
                    log.trace((Object)String.format("  %s: %.100s", field, form.getField(extension, field)));
                }
            }
        }
    }

    protected XmlStreamImportResult initData(WikittyExtension extension) throws Exception {
        List<XmlFieldBinding> bindings = this.createXmlBindings(extension);
        XmlStream xmlStream = this.createXmlStream(extension, bindings);
        return this.storageService.importFormsFromXmlStream(xmlStream);
    }
}

