/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Serializable;

public class CSVStrategy
implements Cloneable,
Serializable {
    private char delimiter;
    private char encapsulator;
    private char commentStart;
    private char escape;
    private boolean ignoreLeadingWhitespaces;
    private boolean ignoreTrailingWhitespaces;
    private boolean interpretUnicodeEscapes;
    private boolean ignoreEmptyLines;
    public static char COMMENTS_DISABLED = (char)65534;
    public static char ESCAPE_DISABLED = (char)65534;
    public static CSVStrategy DEFAULT_STRATEGY = new CSVStrategy(',', '\"', COMMENTS_DISABLED, ESCAPE_DISABLED, true, true, false, true);
    public static CSVStrategy EXCEL_STRATEGY = new CSVStrategy(',', '\"', COMMENTS_DISABLED, ESCAPE_DISABLED, false, false, false, false);
    public static CSVStrategy TDF_STRATEGY = new CSVStrategy('\t', '\"', COMMENTS_DISABLED, ESCAPE_DISABLED, true, true, false, true);

    public CSVStrategy(char delimiter, char encapsulator, char commentStart) {
        this(delimiter, encapsulator, commentStart, true, false, true);
    }

    public CSVStrategy(char delimiter, char encapsulator, char commentStart, char escape, boolean ignoreLeadingWhitespace, boolean ignoreTrailingWhitespace, boolean interpretUnicodeEscapes, boolean ignoreEmptyLines) {
        this.setDelimiter(delimiter);
        this.setEncapsulator(encapsulator);
        this.setCommentStart(commentStart);
        this.setEscape(escape);
        this.setIgnoreLeadingWhitespaces(ignoreLeadingWhitespace);
        this.setIgnoreTrailingWhitespaces(ignoreTrailingWhitespace);
        this.setUnicodeEscapeInterpretation(interpretUnicodeEscapes);
        this.setIgnoreEmptyLines(ignoreEmptyLines);
    }

    public CSVStrategy(char delimiter, char encapsulator, char commentStart, boolean ignoreLeadingWhitespace, boolean interpretUnicodeEscapes, boolean ignoreEmptyLines) {
        this(delimiter, encapsulator, commentStart, ESCAPE_DISABLED, ignoreLeadingWhitespace, true, interpretUnicodeEscapes, ignoreEmptyLines);
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setEncapsulator(char encapsulator) {
        this.encapsulator = encapsulator;
    }

    public char getEncapsulator() {
        return this.encapsulator;
    }

    public void setCommentStart(char commentStart) {
        this.commentStart = commentStart;
    }

    public char getCommentStart() {
        return this.commentStart;
    }

    public boolean isCommentingDisabled() {
        return this.commentStart == COMMENTS_DISABLED;
    }

    public void setEscape(char escape) {
        this.escape = escape;
    }

    public char getEscape() {
        return this.escape;
    }

    public void setIgnoreLeadingWhitespaces(boolean ignoreLeadingWhitespaces) {
        this.ignoreLeadingWhitespaces = ignoreLeadingWhitespaces;
    }

    public boolean getIgnoreLeadingWhitespaces() {
        return this.ignoreLeadingWhitespaces;
    }

    public void setIgnoreTrailingWhitespaces(boolean ignoreTrailingWhitespaces) {
        this.ignoreTrailingWhitespaces = ignoreTrailingWhitespaces;
    }

    public boolean getIgnoreTrailingWhitespaces() {
        return this.ignoreTrailingWhitespaces;
    }

    public void setUnicodeEscapeInterpretation(boolean interpretUnicodeEscapes) {
        this.interpretUnicodeEscapes = interpretUnicodeEscapes;
    }

    public boolean getUnicodeEscapeInterpretation() {
        return this.interpretUnicodeEscapes;
    }

    public void setIgnoreEmptyLines(boolean ignoreEmptyLines) {
        this.ignoreEmptyLines = ignoreEmptyLines;
    }

    public boolean getIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

