/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.search;

import com.jurismarches.vradi.services.search.CompareFilter;
import com.jurismarches.vradi.services.search.Filter;
import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.QueryHandler;
import com.jurismarches.vradi.services.search.RangeFilter;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;

public class FilterListQueryHandler
implements QueryHandler {
    private static final Log log = LogFactory.getLog(FilterListQueryHandler.class);
    protected Stack<FilterList> filterListStack = new Stack();

    public FilterListQueryHandler() {
        FilterList filterList = new FilterList();
        this.filterListStack.push(filterList);
    }

    @Override
    public void prefixQuery(PrefixQuery query, BooleanClause booleanClause) {
        Term term = query.getPrefix();
        CompareFilter filter = new CompareFilter(term.field(), term.text() + "*");
        this.filter(filter, booleanClause);
    }

    @Override
    public void termQuery(TermQuery query, BooleanClause booleanClause) {
        Term term = query.getTerm();
        CompareFilter filter = new CompareFilter(term.field(), term.text());
        this.filter(filter, booleanClause);
    }

    @Override
    public void rangeQuery(TermRangeQuery query, BooleanClause booleanClause) {
        String field = query.getField();
        String lowerTerm = query.getLowerTerm();
        String upperTerm = query.getUpperTerm();
        RangeFilter filter = new RangeFilter(field, lowerTerm, upperTerm);
        this.filter(filter, booleanClause);
    }

    @Override
    public void wildcardQuery(WildcardQuery query, BooleanClause booleanClause) {
        Term term = query.getTerm();
        CompareFilter filter = new CompareFilter(term.field(), term.text());
        this.filter(filter, booleanClause);
    }

    @Override
    public void group(BooleanClause booleanClause) {
        if (booleanClause == null) {
            return;
        }
        FilterList.Operator operator = FilterList.Operator.getOperator(booleanClause);
        FilterList filterList = new FilterList(operator);
        if (log.isTraceEnabled()) {
            log.trace((Object)("group: " + operator.toString()));
        }
        FilterList peek = this.filterListStack.peek();
        peek.addFilter(filterList);
        this.filterListStack.push(filterList);
    }

    @Override
    public void ungroup() {
        if (this.filterListStack.size() > 1) {
            this.filterListStack.pop();
        }
    }

    public FilterList getFilterList() {
        FilterList list = (FilterList)this.filterListStack.get(0);
        if (log.isDebugEnabled()) {
            FilterListQueryHandler.traceFilterList(list, "");
        }
        return list;
    }

    public static String getQueryFromFilterList(FilterList list) {
        if (list == null) {
            return null;
        }
        FilterList parameter = null;
        List<Filter> filters = list.getFilters();
        parameter = filters.size() == 1 && filters.get(0) instanceof FilterList ? (FilterList)filters.get(0) : list;
        String[] result = FilterListQueryHandler.recomposeQuery(parameter);
        return result[0] == null ? result[1] : String.format("%s:(%s)", result[0], result[1]);
    }

    static void traceFilterList(FilterList list, String spaces) {
        FilterList.Operator operator = list.getOperator();
        log.debug((Object)String.format("%s%s [", spaces, operator.toString()));
        spaces = spaces + "  ";
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                FilterListQueryHandler.traceFilterList((FilterList)filter, spaces);
                continue;
            }
            log.debug((Object)String.format("%s%s", spaces, filter.toString()));
        }
        spaces = spaces.substring(0, spaces.length() - 2);
        log.debug((Object)(spaces + "]"));
    }

    private void filter(Filter filter, BooleanClause booleanClause) {
        FilterList peek = this.filterListStack.peek();
        FilterList.Operator operator = FilterList.Operator.getOperator(booleanClause);
        if (operator == FilterList.Operator.FILTER_NOT && peek.getOperator() != operator) {
            this.group(booleanClause);
            peek = this.filterListStack.peek();
            peek.addFilter(filter);
            this.ungroup();
        } else {
            peek.addFilter(filter);
        }
    }

    private static String[] recomposeQuery(FilterList filterList) {
        String[] result = new String[2];
        List<Filter> filters = filterList.getFilters();
        for (Filter filter : filters) {
            String term = null;
            String value = null;
            String openSeparator = null;
            String closeSeparator = null;
            if (filter instanceof FilterList) {
                FilterList lFilter = (FilterList)filter;
                String[] listResult = FilterListQueryHandler.recomposeQuery(lFilter);
                term = listResult[0];
                value = listResult[1];
                openSeparator = "(";
                closeSeparator = ")";
            } else if (filter instanceof CompareFilter) {
                CompareFilter cFilter = (CompareFilter)filter;
                term = cFilter.getName();
                value = "\"" + cFilter.getValue() + "\"";
                openSeparator = "";
                closeSeparator = "";
            }
            if (result[0] == null && result[1] == null) {
                result[0] = term;
                result[1] = String.format("%s%s%s", openSeparator, value, closeSeparator);
                continue;
            }
            if (result[0] != null) {
                if (result[0].equals(term)) {
                    result[1] = String.format("%s %s %s%s%s", result[1], filterList.getOperator().getValue(), openSeparator, value, closeSeparator);
                    continue;
                }
                result[1] = String.format("%s:(%s) %s %s:(%s)", result[0], result[1], filterList.getOperator().getValue(), term, value);
                result[0] = null;
                continue;
            }
            result[1] = String.format("%s %s %s:(%s)", result[1], filterList.getOperator().getValue(), term, value);
        }
        return result;
    }
}

