/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PositionIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public final class PositionRange
extends ComputedExpression {
    private Expression minPosition;
    private Expression maxPosition;

    public PositionRange(Expression expression, Expression expression2) {
        this.minPosition = expression;
        this.maxPosition = expression2;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    public PositionRange(int n, int n2) {
        this.minPosition = new IntegerValue(n);
        this.maxPosition = n2 == Integer.MAX_VALUE ? null : new IntegerValue(n2);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.minPosition = this.minPosition.simplify(staticContext);
        if (this.maxPosition != null) {
            this.maxPosition = this.maxPosition.simplify(staticContext);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.minPosition = this.minPosition.typeCheck(staticContext, itemType);
        if (this.maxPosition != null) {
            this.maxPosition = this.maxPosition.typeCheck(staticContext, itemType);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.minPosition = this.minPosition.optimize(optimizer, staticContext, itemType);
        if (this.maxPosition != null) {
            this.maxPosition = this.maxPosition.optimize(optimizer, staticContext, itemType);
        }
        return this;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        int n = xPathContext.getContextPosition();
        if (this.maxPosition == null) {
            NumericValue numericValue = (NumericValue)this.minPosition.evaluateItem(xPathContext);
            return BooleanValue.get((long)n >= numericValue.longValue());
        }
        NumericValue numericValue = (NumericValue)this.minPosition.evaluateItem(xPathContext);
        NumericValue numericValue2 = (NumericValue)this.maxPosition.evaluateItem(xPathContext);
        return BooleanValue.get((long)n >= numericValue.longValue() && (long)n <= numericValue2.longValue());
    }

    public SequenceIterator makePositionIterator(SequenceIterator sequenceIterator, XPathContext xPathContext) throws XPathException {
        int n;
        NumericValue numericValue = (NumericValue)this.minPosition.evaluateItem(xPathContext);
        int n2 = (int)numericValue.longValue();
        if (this.maxPosition == null) {
            n = Integer.MAX_VALUE;
        } else {
            NumericValue numericValue2 = (NumericValue)this.maxPosition.evaluateItem(xPathContext);
            n = (int)numericValue2.longValue();
        }
        return PositionIterator.make(sequenceIterator, n2, n);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BOOLEAN_TYPE;
    }

    public int computeCardinality() {
        return 16384;
    }

    public int getIntrinsicDependencies() {
        return 4;
    }

    public Iterator iterateSubExpressions() {
        if (this.maxPosition == null) {
            return new MonoIterator(this.minPosition);
        }
        return new PairIterator(this.minPosition, this.maxPosition);
    }

    public boolean isFirstPositionOnly() {
        try {
            return this.minPosition instanceof NumericValue && ((NumericValue)this.minPosition).longValue() == 1L && this.maxPosition instanceof NumericValue && ((NumericValue)this.maxPosition).longValue() == 1L;
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public boolean hasFocusDependentRange() {
        return (this.minPosition.getDependencies() & 0x1E) != 0 || this.maxPosition != null && (this.maxPosition.getDependencies() & 0x1E) != 0;
    }

    public boolean matchesAtMostOneItem() {
        return this.maxPosition != null && this.minPosition.equals(this.maxPosition) && !this.hasFocusDependentRange();
    }

    public TailExpression makeTailExpression(Expression expression) {
        if (this.maxPosition == null && this.minPosition instanceof IntegerValue) {
            return new TailExpression(expression, (int)((IntegerValue)this.minPosition).longValue());
        }
        return null;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "positionRange");
        this.minPosition.display(n + 1, namePool, printStream);
        this.maxPosition.display(n + 1, namePool, printStream);
    }
}

