/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.webharvest.utils.KeyValuePair;

public class HttpResponseWrapper {
    private String charset;
    private String mimeType;
    private byte[] body;
    private KeyValuePair<String>[] headers;
    private int statusCode;
    private String statusText;

    public HttpResponseWrapper(HttpMethodBase method) {
        try {
            this.body = method.getResponseBody();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Header[] headerArray = method.getResponseHeaders();
        if (headerArray != null) {
            this.headers = new KeyValuePair[headerArray.length];
            for (int i = 0; i < headerArray.length; ++i) {
                String currName = headerArray[i].getName();
                String currValue = headerArray[i].getValue();
                this.headers[i] = new KeyValuePair<String>(currName, currValue);
                if (!"content-type".equalsIgnoreCase(currName)) continue;
                int index = currValue.indexOf(59);
                this.mimeType = index > 0 ? currValue.substring(0, index) : currValue;
            }
        }
        this.charset = method.getResponseCharSet();
        this.statusCode = method.getStatusCode();
        this.statusText = method.getStatusText();
    }

    public long getContentLength() {
        return this.body == null ? 0L : (long)this.body.length;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getBody() {
        return this.body;
    }

    public InputStream getBodyAsInputStream() {
        return new ByteArrayInputStream(this.body);
    }

    public KeyValuePair<String>[] getHeaders() {
        return this.headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }
}

