/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.EntityHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.WebHarvestStream;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.Configuration;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.DateParser;
import com.jurismarches.vradi.services.managers.FormManager;
import com.jurismarches.vradi.services.managers.FormTypeManager;
import com.jurismarches.vradi.services.managers.PropertiesManager;
import com.jurismarches.vradi.util.SSLUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;
import org.webharvest.definition.ScraperConfiguration;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.variables.Variable;

public class BindingManager {
    private static final Log log = LogFactory.getLog(BindingManager.class);
    private final WikittyProxy proxy;
    private final FormTypeManager formTypeManager;
    private final FormManager formManager;
    private Timer timer = null;
    private TimerTask xmlStreamTask = null;

    public BindingManager(WikittyProxy proxy, FormTypeManager formTypeManager, FormManager formManager) {
        this.proxy = proxy;
        this.formTypeManager = formTypeManager;
        this.formManager = formManager;
    }

    public BindingManager(FormTypeManager formTypeManager, FormManager formManager) {
        this.proxy = ServiceFactory.getWikittyProxy();
        this.formTypeManager = formTypeManager;
        this.formManager = formManager;
    }

    public List<XmlFieldBinding> getXmlFieldBindings(XmlStream xmlStream) {
        ArrayList<XmlFieldBinding> list = new ArrayList<XmlFieldBinding>();
        if (xmlStream != null && xmlStream.getXmlFieldBinding() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getXmlFieldBindings(" + xmlStream.getName() + ")"));
                log.debug((Object)xmlStream.getXmlFieldBinding());
            }
            ArrayList bindings = new ArrayList();
            bindings.addAll(xmlStream.getXmlFieldBinding());
            List restore = this.proxy.restore(XmlFieldBinding.class, bindings);
            list.addAll(restore);
        }
        return list;
    }

    public XmlFieldBinding getXmlFieldBinding(String xmlFieldBindingId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getXmlFieldBinding(" + xmlFieldBindingId + ")"));
        }
        XmlFieldBinding xmlFieldBinding = (XmlFieldBinding)this.proxy.restore(XmlFieldBinding.class, xmlFieldBindingId);
        return xmlFieldBinding;
    }

    public List<XmlStream> getAllXmlStreams() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllXmlStreams()");
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "XmlStream").criteria();
        PagedResult xmlStreams = this.proxy.findAllByCriteria(XmlStream.class, criteria);
        List all = xmlStreams.getAll();
        ArrayList list = new ArrayList();
        list.addAll(all);
        return EntityHelper.castAsRealStreams(list);
    }

    public List<WebHarvestStream> getAllWebHarvestStreams() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllWebHarvestStreams()");
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "WebHarvestStream").criteria();
        PagedResult xmlStreams = this.proxy.findAllByCriteria(WebHarvestStream.class, criteria);
        List all = xmlStreams.getAll();
        ArrayList<WebHarvestStream> list = new ArrayList<WebHarvestStream>();
        list.addAll(all);
        return list;
    }

    public URI getWebHarvestPreviewUrl(WebHarvestStream stream) throws VradiException {
        String path = this.getWebHarvestPreviewPath(stream);
        File previewFile = new File(path);
        if (!previewFile.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Preview file doesnt exist, creating one for script path : " + path));
            }
            previewFile = this.createPreviewFile(stream);
        }
        URI uri = previewFile.toURI();
        return uri;
    }

    public String getWebHarvestPreviewUrlAsString(WebHarvestStream stream) throws VradiException {
        String uri = this.getWebHarvestPreviewUrl(stream).toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Previews url is : " + uri));
        }
        return uri;
    }

    public String getWebHarvestPreviewPath(WebHarvestStream stream) {
        File scriptFile = new File(Configuration.getInstance().getWebHarvestScriptDir() + File.separator + stream.getScriptUrl());
        String previewPath = Configuration.getInstance().getWebHarvestPreviewDir() + File.separator + "Preview" + scriptFile.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Previews path is : " + previewPath));
        }
        return previewPath;
    }

    public XmlStream getXmlStream(String xmlStreamId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getXmlStream(" + xmlStreamId + ")"));
        }
        XmlStream xmlStream = (XmlStream)this.proxy.restore(XmlStream.class, xmlStreamId);
        return xmlStream;
    }

    protected FormImpl createForm(WikittyExtension formType, List<XmlFieldBinding> bindings, org.jdom.Element feed, Namespace namespace, BindingContext bindingContext) throws VradiException {
        FormImpl form = new FormImpl();
        Wikitty wikitty = form.getWikitty();
        wikitty.addExtension(formType);
        for (XmlFieldBinding binding : bindings) {
            FieldType fieldType;
            String fqFormField = binding.getFormField();
            try {
                fieldType = wikitty.getFieldType(fqFormField);
            }
            catch (Exception e) {
                continue;
            }
            this.fillFormField(wikitty, fieldType, binding, feed, namespace, bindingContext);
        }
        return form;
    }

    protected void fillFormField(Wikitty wikitty, FieldType fieldType, XmlFieldBinding binding, org.jdom.Element feed, Namespace namespace, BindingContext bindingContext) throws VradiException {
        String fqFormField = binding.getFormField();
        Set xmlFields = binding.getXmlField();
        if (xmlFields == null || xmlFields.isEmpty()) {
            String defaultValue = binding.getDefaultValue();
            this.fillFormField2(wikitty, fieldType, fqFormField, defaultValue, bindingContext);
            return;
        }
        for (String xmlField : xmlFields) {
            org.jdom.Element child = feed.getChild(xmlField, namespace);
            String feedValue = null;
            if (child != null) {
                feedValue = child.getTextTrim();
            }
            if (feedValue == null || feedValue.isEmpty()) {
                feedValue = binding.getDefaultValue();
            }
            this.fillFormField2(wikitty, fieldType, fqFormField, feedValue, bindingContext);
        }
    }

    private void fillFormField2(Wikitty wikitty, FieldType fieldType, String fqFormField, String feedValue, BindingContext bindingContext) throws VradiException {
        if (feedValue == null || feedValue.isEmpty()) {
            return;
        }
        switch (fieldType.getType()) {
            case DATE: {
                Date date = DateParser.parse(feedValue);
                if (date != null) {
                    try {
                        wikitty.setFqField(fqFormField, (Object)WikittyUtil.formatDate((Date)date));
                        break;
                    }
                    catch (ParseException eee) {
                        throw new VradiException("Cant parse date " + date, eee);
                    }
                }
                ++bindingContext.dateParsingError;
                break;
            }
            case NUMERIC: {
                if (NumberUtils.isNumber((String)feedValue)) {
                    Double value = Double.valueOf(feedValue);
                    wikitty.setFqField(fqFormField, (Object)value);
                    break;
                }
                ++bindingContext.numberParsingError;
                break;
            }
            default: {
                Object fieldValue = wikitty.getFqField(fqFormField);
                String newValue = null;
                newValue = fieldValue != null ? fieldValue + "\n" + feedValue : feedValue;
                wikitty.setFqField(fqFormField, (Object)newValue);
            }
        }
    }

    public int[] getFormsFromWebHarvestStream(WebHarvestStream webHarvestStream) throws VradiException {
        log.info((Object)("getFormsFromWebHarvestStream for " + webHarvestStream.getName()));
        File previewFile = this.createPreviewFile(webHarvestStream, true);
        Document document = null;
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build(previewFile);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't read xml stream", (Throwable)e);
            }
            throw new VradiException("Can't read xml stream : ", e);
        }
        return this.getFormsFromStream(webHarvestStream, document);
    }

    public File createPreviewFile(WebHarvestStream webHarvestStream) throws VradiException {
        return this.createPreviewFile(webHarvestStream, false);
    }

    protected File createPreviewFile(WebHarvestStream webHarvestStream, boolean override) throws VradiException {
        String path = webHarvestStream.getScriptUrl();
        if (path == null) {
            return null;
        }
        path = Configuration.getInstance().getWebHarvestPreviewDir() + File.separator + path;
        File scriptFile = new File(path);
        if (!override && scriptFile.exists()) {
            return scriptFile;
        }
        ScraperConfiguration config = null;
        try {
            config = new ScraperConfiguration(scriptFile);
        }
        catch (FileNotFoundException eee) {
            throw new VradiException("Cant open script " + webHarvestStream.getScriptUrl(), eee);
        }
        Configuration appConfig = Configuration.getInstance();
        Scraper scraper = new Scraper(config, appConfig.getDataDir());
        scraper.setDebug(log.isDebugEnabled());
        scraper.addVariableToContext("url", (Object)webHarvestStream.getUrl());
        long startTime = System.currentTimeMillis();
        scraper.execute();
        log.info((Object)("Script execution time elapsed: " + (System.currentTimeMillis() - startTime)));
        Variable resultVar = (Variable)scraper.getContext().get((Object)"result");
        String result = resultVar.toString();
        result = result.replaceAll("&", "&amp;");
        File previewFile = new File(path);
        try {
            FileUtils.writeStringToFile((File)previewFile, (String)result);
            log.info((Object)("Store preview for script " + scriptFile.getPath()));
        }
        catch (IOException eee) {
            log.error((Object)("Failed to write preview for script " + scriptFile.getName()), (Throwable)eee);
        }
        return previewFile;
    }

    public int[] getFormsFromXmlStream(XmlStream xmlStream) throws VradiException {
        Document document = null;
        try {
            SAXBuilder sxb = new SAXBuilder(false);
            sxb.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            URL rssUrl = new URL(xmlStream.getUrl());
            log.info((Object)("Reading xmlStream url from: " + rssUrl));
            document = sxb.build(rssUrl);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't read xml stream", (Throwable)e);
            }
            throw new VradiException("Can't read xml stream : ", e);
        }
        return this.getFormsFromStream(xmlStream, document);
    }

    public <E extends XmlStream> int[] getFormsFromStream(E stream, Document document) throws VradiException {
        int[] results = new int[4];
        String lastItemRecorded = PropertiesManager.getLastItemOfXmlStream(stream.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFormsFromStream(" + stream.getName() + ", " + lastItemRecorded));
        }
        if (stream.getFormTypeName() == null) {
            throw new VradiException("xmlStream.formTypeName is null");
        }
        WikittyExtension formType = this.formTypeManager.getFormType(stream.getFormTypeName());
        if (formType == null) {
            throw new VradiException("Extension of name xmlStream.formTypeName does not exists");
        }
        org.jdom.Element racine = document.getRootElement();
        Namespace namespace = racine.getNamespace("");
        List elements = null;
        if (racine.getChild("item", namespace) != null) {
            elements = racine.getChildren("item", namespace);
        } else if (racine.getChild("channel", namespace) != null) {
            org.jdom.Element channel = racine.getChild("channel", namespace);
            elements = channel.getChildren("item", namespace);
        } else if (racine.getChild("entry", namespace) != null) {
            elements = racine.getChildren("entry", namespace);
        }
        if (elements == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Enable to find items or entries in stream");
            }
            return results;
        }
        int index = 0;
        boolean itemAlreadyRecorded = false;
        ArrayList<String> encryptedElements = new ArrayList<String>();
        while (index < elements.size() && !itemAlreadyRecorded) {
            String encryptedItemValue;
            block19: {
                org.jdom.Element element = (org.jdom.Element)elements.get(index);
                StringBuffer sb = new StringBuffer();
                List fields = element.getChildren();
                for (org.jdom.Element field : fields) {
                    sb.append(field.getText());
                }
                encryptedItemValue = null;
                try {
                    encryptedItemValue = StringUtil.encodeMD5((String)sb.toString());
                }
                catch (NoSuchAlgorithmException eee) {
                    if (!log.isFatalEnabled()) break block19;
                    log.fatal((Object)"No MD5 algorithm found");
                }
            }
            if (lastItemRecorded != null && lastItemRecorded.equals(encryptedItemValue)) {
                itemAlreadyRecorded = true;
                continue;
            }
            encryptedElements.add(encryptedItemValue);
            ++index;
        }
        if (--index >= 0) {
            String lastItemOfXmlStream = null;
            ArrayList<Form> forms = new ArrayList<Form>();
            List bindings = this.proxy.restore(XmlFieldBinding.class, new ArrayList(stream.getXmlFieldBinding()));
            String formId = VradiConstants.FORM_ID_DATE_FORMAT.format(new Date());
            String toTreatId = this.formManager.getNonTraiteStatus().getWikittyId();
            BindingContext bindingContext = new BindingContext();
            for (int i = index; i >= 0; --i) {
                org.jdom.Element feed = (org.jdom.Element)elements.get(i);
                FormImpl form = this.createForm(formType, bindings, feed, namespace, bindingContext);
                ++bindingContext.nbCreated;
                form.setId(formId + form.getWikittyId());
                form.setXmlStream(stream.getWikittyId());
                form.setStatus(toTreatId);
                forms.add((Form)form);
                lastItemOfXmlStream = (String)encryptedElements.get(i);
                if (forms.size() <= 1000) continue;
                this.formManager.updateForms(forms);
                PropertiesManager.setLastItemOfXmlStream(stream.getName(), lastItemOfXmlStream);
                forms.clear();
            }
            if (!forms.isEmpty()) {
                this.formManager.updateForms(forms);
                PropertiesManager.setLastItemOfXmlStream(stream.getName(), lastItemOfXmlStream);
            }
            results[0] = bindingContext.nbCreated;
            results[2] = bindingContext.dateParsingError;
            results[3] = bindingContext.numberParsingError;
        }
        results[1] = elements.size() - results[0];
        if (log.isInfoEnabled()) {
            log.info((Object)("Form import from stream, created = " + results[0]));
            log.info((Object)("Form import from stream, already existing = " + results[1]));
            log.info((Object)("Form import from stream, dateParsingError = " + results[2]));
            log.info((Object)("Form import from stream, numberParsingError = " + results[3]));
        }
        return results;
    }

    public void autoLoadFormsFromXmlStreams(String intervalUnit, int intervalValue, Integer hour, Integer minute) throws VradiException {
        int delayInMinute = 0;
        int intervalUnitInMinutes = 0;
        GregorianCalendar cal = new GregorianCalendar();
        int calHour = cal.get(11);
        int calMinute = cal.get(12);
        int diffMinute = 0;
        int diffHour = 0;
        if (minute != null) {
            diffMinute = (60 + minute - calMinute) % 60;
            if (hour != null) {
                diffHour = (24 + hour - calHour - 1 + (60 + minute - calMinute) / 60) % 24;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("delay : " + diffHour + " hours " + diffMinute + " minutes"));
        }
        if (VradiConstants.XmlStreamConfig.HOURS.toString().equals(intervalUnit)) {
            intervalUnitInMinutes = 60;
            delayInMinute = diffMinute;
        } else if (VradiConstants.XmlStreamConfig.DAYS.toString().equals(intervalUnit)) {
            intervalUnitInMinutes = 1440;
            delayInMinute = diffMinute + diffHour * 60;
        } else if (VradiConstants.XmlStreamConfig.MINUTES.toString().equals(intervalUnit)) {
            intervalUnitInMinutes = 1;
            delayInMinute = minute;
        }
        int interval = intervalValue * intervalUnitInMinutes * 60 * 1000;
        int delay = delayInMinute * 60 * 1000;
        this.autoLoadFormsFromXmlStreams(delay, interval);
        PropertiesManager.setXmlStreamConfig(intervalUnit, String.valueOf(intervalValue), hour == null ? null : String.valueOf(hour), minute == null ? null : String.valueOf(minute));
    }

    protected void autoLoadFormsFromXmlStreams(long delay, long period) throws VradiException {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        if (this.xmlStreamTask != null) {
            this.xmlStreamTask.cancel();
            this.timer.purge();
        }
        this.xmlStreamTask = new TimerTask(){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Update xml streams task");
                }
                List<XmlStream> xmlStreams = BindingManager.this.getAllXmlStreams();
                for (XmlStream xmlStream : xmlStreams) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loading forms from " + xmlStream.getName()));
                    }
                    try {
                        BindingManager.this.getFormsFromXmlStream(xmlStream);
                    }
                    catch (VradiException eee) {
                        log.error((Object)("can't create forms from stream : " + xmlStream.getName()));
                    }
                }
                List<WebHarvestStream> webHarvestStreams = BindingManager.this.getAllWebHarvestStreams();
                for (WebHarvestStream webHarvestStream : webHarvestStreams) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loading forms from web harvest stream " + webHarvestStream.getName()));
                    }
                    try {
                        BindingManager.this.getFormsFromWebHarvestStream(webHarvestStream);
                    }
                    catch (VradiException eee) {
                        log.error((Object)("can't create forms from web harvest stream : " + webHarvestStream.getName()));
                    }
                }
            }
        };
        this.timer.scheduleAtFixedRate(this.xmlStreamTask, delay, period);
    }

    static {
        SSLUtils.intallCertificateTruster();
    }

    private static class BindingContext {
        int dateParsingError = 0;
        int numberParsingError = 0;
        int nbCreated = 0;

        private BindingContext() {
        }
    }
}

