/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.services.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class PropertiesManager {
    private static final Log log = LogFactory.getLog(PropertiesManager.class);
    private static File commonPropertiesFile;

    public static synchronized File getCommonPropertiesFile() {
        if (commonPropertiesFile == null) {
            commonPropertiesFile = Configuration.getInstance().getCommonsPropertiesFile();
        }
        return commonPropertiesFile;
    }

    protected static Properties getCommonProperties() {
        Properties commonProperties = PropertiesManager.getProperties(PropertiesManager.getCommonPropertiesFile());
        return commonProperties;
    }

    protected static synchronized Properties getProperties(File propertyFile) {
        try {
            Properties properties = new Properties();
            if (propertyFile.exists()) {
                FileInputStream input = new FileInputStream(propertyFile);
                properties.load(input);
                ((InputStream)input).close();
            }
            return properties;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("could not get " + propertyFile.getName() + " caused by : " + ioe.getMessage(), ioe);
        }
    }

    protected static synchronized Properties store(Properties property, File file) {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            OutputStreamWriter fileOutputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1");
            property.store(fileOutputStream, "");
            ((Writer)fileOutputStream).close();
        }
        catch (IOException e) {
            log.error((Object)"Cant save request property caused by : ", (Throwable)e);
        }
        return property;
    }

    protected static List<String> getCommonListOfStringFromProperties(String propertyName) {
        Properties properties = PropertiesManager.getCommonProperties();
        ArrayList<String> result = new ArrayList<String>();
        if (properties != null) {
            String resultNames = properties.getProperty(propertyName);
            if (resultNames != null) {
                for (String resultName : resultNames.split(",")) {
                    String utf8ResultName = null;
                    try {
                        utf8ResultName = new String(resultName.getBytes("ISO-8859-1"), "UTF-8");
                    }
                    catch (UnsupportedEncodingException eee) {
                        utf8ResultName = resultName;
                    }
                    result.add(utf8ResultName);
                }
            } else {
                log.warn((Object)("Cant find property : " + propertyName));
            }
        }
        return result;
    }

    protected static void storeCommonListProperties(String propertyName, List<String> values) {
        Properties properties = PropertiesManager.getCommonProperties();
        if (properties != null) {
            StringBuffer store = new StringBuffer();
            for (String value : values) {
                store.append(value).append(",");
            }
            int length = store.length() - 1;
            if (length > 0) {
                store.deleteCharAt(length);
            }
            properties.setProperty(propertyName, store.toString());
            PropertiesManager.store(properties, PropertiesManager.getCommonPropertiesFile());
        }
    }

    protected static void addToCommonListProperties(String propertyName, String value) {
        PropertiesManager.addToCommonListProperties(propertyName, value, false);
    }

    protected static void addToCommonListProperties(String propertyName, String value, boolean replace) {
        PropertiesManager.addToCommonListProperties(propertyName, value, replace, false, false);
    }

    protected static void addToCommonListProperties(String propertyName, String value, boolean replace, boolean inverse, boolean uniqueValues) {
        ArrayList<String> result;
        List<Object> list = result = replace ? new ArrayList() : PropertiesManager.getCommonListOfStringFromProperties(propertyName);
        if (value != null) {
            String isoValue;
            try {
                isoValue = new String(value.getBytes("UTF-8"), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException eee) {
                isoValue = value;
            }
            if (uniqueValues && result.contains(isoValue)) {
                result.remove(isoValue);
                if (inverse) {
                    result.add(0, isoValue);
                } else {
                    result.add(isoValue);
                }
            } else if (inverse) {
                result.add(0, isoValue);
            } else {
                result.add(isoValue);
            }
        }
        PropertiesManager.storeCommonListProperties(propertyName, result);
    }

    protected static List<String> removeToCommonListProperties(String propertyName, String value) {
        List<String> result = PropertiesManager.getCommonListOfStringFromProperties(propertyName);
        result.remove(value);
        PropertiesManager.storeCommonListProperties(propertyName, result);
        return result;
    }

    public static void setLastItemOfXmlStream(String xmlStreamName, String value) {
        PropertiesManager.addToCommonListProperties(VradiConstants.XmlStreamConfig.XML_STREAMS.toString() + "." + xmlStreamName, value, true);
    }

    public static String getLastItemOfXmlStream(String xmlStreamName) {
        List<String> prop = PropertiesManager.getCommonListOfStringFromProperties(VradiConstants.XmlStreamConfig.XML_STREAMS.toString() + "." + xmlStreamName);
        if (!prop.isEmpty()) {
            return prop.get(0);
        }
        return null;
    }

    public static void setXmlStreamConfig(String intervalUnit, String intervalValue, String hour, String minute) {
        if (intervalUnit != null) {
            PropertiesManager.addToCommonListProperties(VradiConstants.XmlStreamConfig.XML_STREAMS_CONFIG_INTERVAL_UNIT.toString(), intervalUnit, true);
        }
        if (intervalValue != null) {
            PropertiesManager.addToCommonListProperties(VradiConstants.XmlStreamConfig.XML_STREAMS_CONFIG_INTERVAL_VALUE.toString(), intervalValue, true);
        }
        if (hour != null) {
            PropertiesManager.addToCommonListProperties(VradiConstants.XmlStreamConfig.XML_STREAMS_CONFIG_INTERVAL_HOUR.toString(), hour, true);
        }
        if (minute != null) {
            PropertiesManager.addToCommonListProperties(VradiConstants.XmlStreamConfig.XML_STREAMS_CONFIG_INTERVAL_MINUTE.toString(), minute, true);
        }
    }

    public static String[] getXmlStreamConfig() {
        List<String> propMinute;
        List<String> propHour;
        List<String> propValue;
        String[] result = new String[4];
        List<String> propUnit = PropertiesManager.getCommonListOfStringFromProperties(VradiConstants.XmlStreamConfig.XML_STREAMS_CONFIG_INTERVAL_UNIT.toString());
        if (!propUnit.isEmpty()) {
            result[0] = propUnit.get(0);
        }
        if (!(propValue = PropertiesManager.getCommonListOfStringFromProperties(VradiConstants.XmlStreamConfig.XML_STREAMS_CONFIG_INTERVAL_VALUE.toString())).isEmpty()) {
            result[1] = propValue.get(0);
        }
        if (!(propHour = PropertiesManager.getCommonListOfStringFromProperties(VradiConstants.XmlStreamConfig.XML_STREAMS_CONFIG_INTERVAL_HOUR.toString())).isEmpty()) {
            result[2] = propHour.get(0);
        }
        if (!(propMinute = PropertiesManager.getCommonListOfStringFromProperties(VradiConstants.XmlStreamConfig.XML_STREAMS_CONFIG_INTERVAL_MINUTE.toString())).isEmpty()) {
            result[3] = propMinute.get(0);
        }
        return result;
    }
}

