/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.SendingBean;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiDTO;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import com.jurismarches.vradi.services.dto.VradiGroupDTO;
import com.jurismarches.vradi.services.dto.VradiSessionDTO;
import com.jurismarches.vradi.services.dto.VradiUserDTO;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VradiSendingDTO
extends SendingBean
implements VradiDTO<Sending> {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(VradiSendingDTO.class);
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    protected VradiUserDTO userDTO = null;
    protected VradiClientDTO clientDTO = null;
    protected VradiGroupDTO groupDTO = null;
    protected List<VradiFormDTO> formDTOs;
    protected VradiSessionDTO session;

    public VradiSendingDTO() {
        this.Sending$form = new HashSet();
        this.Sending$deletedForms = new HashSet();
        this.formDTOs = new ArrayList<VradiFormDTO>();
    }

    @Override
    public void fromWikitty(Sending wikitty) {
        if (wikitty == null) {
            this.reset();
        } else {
            Set deletedFormsIds;
            this.setWikittyId(wikitty.getWikittyId());
            this.setParagraph(wikitty.getParagraph());
            this.setReceptionProof(wikitty.getReceptionProof());
            this.setStatus(wikitty.getStatus());
            this.setReceptionDate(wikitty.getReceptionDate());
            this.setSentDate(wikitty.getSentDate());
            this.setClient(wikitty.getClient());
            this.setUser(wikitty.getUser());
            this.setGroup(wikitty.getGroup());
            Set formsIds = wikitty.getForm();
            if (formsIds != null) {
                for (String f : formsIds) {
                    this.addForm(f);
                }
            }
            if ((deletedFormsIds = wikitty.getDeletedForms()) != null) {
                for (String f : deletedFormsIds) {
                    this.addDeletedForms(f);
                }
            }
        }
    }

    @Override
    public void toWikitty(Sending wikitty) {
        Set deletedFormsIds;
        wikitty.setParagraph(this.getParagraph());
        wikitty.setReceptionProof(this.getReceptionProof());
        wikitty.setStatus(this.getStatus());
        wikitty.setReceptionDate(this.getReceptionDate());
        wikitty.setSentDate(this.getSentDate());
        wikitty.setUser(this.getUser());
        wikitty.setClient(this.getClient());
        wikitty.setGroup(this.getGroup());
        Set formsIds = this.getForm();
        if (formsIds != null) {
            for (String f : formsIds) {
                wikitty.addForm(f);
            }
        }
        if ((deletedFormsIds = this.getDeletedForms()) != null) {
            for (String f : deletedFormsIds) {
                wikitty.addDeletedForms(f);
            }
        }
    }

    @Override
    public void reset() {
        this.setParagraph(null);
        this.setReceptionProof(false);
        this.setStatus(0);
        this.setReceptionDate(null);
        this.setSentDate(null);
        this.setClient(null);
        this.setUser(null);
        this.setGroup(null);
        this.clearForm();
        this.clearDeletedForms();
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        this.propertyChange.firePropertyChange("wikittyId", old, id);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(propertyName, listener);
    }

    public List<VradiFormDTO> getFormDTOs() {
        return this.formDTOs;
    }

    public void addFormDTO(Form form) {
        if (form != null) {
            List<VradiFormDTO> oldValue = this.formDTOs;
            if (this.formDTOs == null) {
                this.formDTOs = new ArrayList<VradiFormDTO>();
            }
            this.addForm(form.getWikittyId());
            VradiFormDTO formDTO = new VradiFormDTO();
            formDTO.fromWikitty(form);
            this.formDTOs.add(formDTO);
            this.propertyChange.firePropertyChange("formDTOs", oldValue, this.formDTOs);
        }
    }

    public void setFormDTOs(List<VradiFormDTO> formDTOs) {
        if (formDTOs != null) {
            List<VradiFormDTO> oldValue = formDTOs;
            this.formDTOs = formDTOs;
            this.propertyChange.firePropertyChange("formDTOs", oldValue, formDTOs);
        }
    }

    public void removeFormDTO(VradiFormDTO form) {
        if (form != null) {
            this.formDTOs.remove(form);
            this.removeForm(form.getWikittyId());
        }
    }

    public void setSentDate(Date value) {
        Date oldValue = this.getSentDate();
        super.setSentDate(value);
        this.propertyChange.firePropertyChange("sentDate", oldValue, value);
    }

    public Date getSentDate() {
        return super.getSentDate();
    }

    public void setReceptionDate(Date value) {
        Date oldValue = this.getReceptionDate();
        super.setReceptionDate(value);
        this.propertyChange.firePropertyChange("receptionDate", oldValue, value);
    }

    public Date getReceptionDate() {
        return super.getReceptionDate();
    }

    public void setParagraph(String value) {
        String oldValue = this.getParagraph();
        super.setParagraph(value);
        this.propertyChange.firePropertyChange("paragraph", oldValue, value);
    }

    public String getParagraph() {
        return super.getParagraph();
    }

    public void setReceptionProof(boolean value) {
        boolean oldValue = this.getReceptionProof();
        super.setReceptionProof(value);
        this.propertyChange.firePropertyChange("receptionProof", oldValue, value);
    }

    public boolean getReceptionProof() {
        return super.getReceptionProof();
    }

    public void setStatus(int value) {
        int oldValue = this.getStatus();
        super.setStatus(value);
        this.propertyChange.firePropertyChange("status", oldValue, value);
    }

    public int getStatus() {
        return super.getStatus();
    }

    public <E extends QueryMaker> void setQueryMakerDTO(E queryMaker) {
        if (queryMaker instanceof VradiClientDTO) {
            this.setClientDTO((VradiClientDTO)queryMaker);
        } else if (queryMaker instanceof VradiUserDTO) {
            this.setUserDTO((VradiUserDTO)queryMaker);
        } else if (queryMaker instanceof VradiGroupDTO) {
            this.setGroupDTO((VradiGroupDTO)queryMaker);
        }
    }

    public QueryMaker getQueryMakerDTO() {
        if (this.getClientDTO() != null) {
            return this.getClientDTO();
        }
        if (this.getUserDTO() != null) {
            return this.getUserDTO();
        }
        if (this.getGroupDTO() != null) {
            return this.getGroupDTO();
        }
        return null;
    }

    public VradiUserDTO getUserDTO() {
        return this.userDTO;
    }

    public void setUserDTO(VradiUserDTO userDTO) {
        VradiUserDTO oldValue = this.userDTO;
        this.userDTO = userDTO;
        this.propertyChange.firePropertyChange("userDTO", oldValue, userDTO);
    }

    public VradiClientDTO getClientDTO() {
        return this.clientDTO;
    }

    public void setClientDTO(VradiClientDTO clientDTO) {
        VradiClientDTO oldValue = this.clientDTO;
        this.clientDTO = clientDTO;
        this.propertyChange.firePropertyChange("clientDTO", oldValue, clientDTO);
    }

    public VradiGroupDTO getGroupDTO() {
        return this.groupDTO;
    }

    public void setGroupDTO(VradiGroupDTO groupDTO) {
        VradiGroupDTO oldValue = this.groupDTO;
        this.groupDTO = groupDTO;
        this.propertyChange.firePropertyChange("groupDTO", oldValue, groupDTO);
    }

    public void setSessionDTO(VradiSessionDTO session) {
        this.session = session;
    }

    public VradiSessionDTO getSessionDTO() {
        return this.session;
    }
}

