/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.aspect;

import com.jurismarches.vradi.aspect.VradiTrace;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.aspectwerkz.annotation.AfterFinally;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.annotation.Before;
import org.codehaus.aspectwerkz.annotation.Expression;
import org.codehaus.aspectwerkz.definition.Pointcut;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MethodSignature;

@Aspect(value="perJVM")
public class ServiceAspect {
    @Expression(value="execution(* com.jurismarches.vradi.services..*(..)) && !execution(* com.jurismarches.vradi.services.dto..*(..)) && !execution(@Test * com.jurismarches.vradi.services.*Test.*(..))")
    Pointcut executeMethod;
    @Expression(value="execution(* com.jurismarches.vradi.services.VradiStorageServiceImpl.*(..))")
    Pointcut statMethod;
    TraceLocal traceLocal = new TraceLocal();
    static List<ServiceAspect> instances = new ArrayList<ServiceAspect>();

    public ServiceAspect() {
        instances.add(this);
    }

    protected VradiTrace getTrace() {
        return (VradiTrace)this.traceLocal.get();
    }

    @Before(value="executeMethod || statMethod")
    public void traceBeforeExecute(JoinPoint jp) {
        this.getTrace().traceBefore();
    }

    @AfterFinally(value="executeMethod")
    public void traceAfterExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        this.getTrace().traceAfterCall(method);
    }

    @AfterFinally(value="statMethod")
    public void statAfterExecute(JoinPoint jp) {
        this.traceAfterExecute(jp);
        this.getTrace().printStatisticAndClear();
    }

    static class TraceLocal
    extends ThreadLocal<VradiTrace> {
        TraceLocal() {
        }

        @Override
        protected VradiTrace initialValue() {
            return new VradiTrace(Thread.currentThread().getName());
        }
    }
}

