/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiTestAbstract;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.services.MailingService;
import com.jurismarches.vradi.services.MailingServiceImpl;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.MailingManager;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.util.Resource;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;

public class MailingServiceTest
extends VradiTestAbstract {
    private static final Log log = LogFactory.getLog(MailingServiceTest.class);
    protected MailingService mailingService = new MailingServiceImpl();

    protected WikittyExtension createPersonneFormType() throws Exception {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put("nom", FieldTypeEnum.STRING.getFieldType());
        fields.put("prenom", FieldTypeEnum.STRING.getFieldType());
        return this.createFormType("Personne", fields);
    }

    @Test
    public void testFieldNames() throws Exception {
        URL resource = Resource.getURL((String)"test.ott");
        try {
            String[] fieldNames = this.mailingService.getDocumentFields(new File(resource.getFile()));
            Assert.assertEquals((long)fieldNames.length, (long)2L);
            Assert.assertEquals((Object)fieldNames[0], (Object)"nom");
            Assert.assertEquals((Object)fieldNames[1], (Object)"prenom");
        }
        catch (VradiException eee) {
            log.error((Object)("OOo cannot be loaded : " + (Object)((Object)eee)));
        }
    }

    @Test
    public void testGeneration() throws Exception {
        URL resource = Resource.getURL((String)"test.ott");
        try {
            ArrayList<FormImpl> forms = new ArrayList<FormImpl>();
            WikittyExtension formType = this.createPersonneFormType();
            FormImpl form = new FormImpl();
            Wikitty wikitty = form.getWikitty();
            wikitty.addExtension(formType);
            form.setField("Personne", "nom", (Object)"Morin");
            form.setField("Personne", "prenom", (Object)"Kevin");
            forms.add(form);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nom", "Personne.nom");
            map.put("prenom", "Personne.prenom");
            List files = this.mailingService.generateFilledDocumentInPDF(new File(resource.getFile()), forms, map);
            Assert.assertNotNull((Object)files);
            for (File file : files) {
                Assert.assertNotNull((Object)file);
                Assert.assertTrue((boolean)file.exists());
            }
            try {
                MailingManager mailingManager = new MailingManager(null);
                mailingManager.postMail("test@codelutin.com", "test", "ceci est un test avec des pdf attach\u00e9s", forms, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (VradiException eee) {
            log.error((Object)("OOo cannot be loaded : " + (Object)((Object)eee)));
        }
    }

    public void testPostMessage() throws VradiException {
        MailingManager mailingManager = new MailingManager(null);
        mailingManager.postMail("toto@codelutin.com", "test", "ceci est un test", null, true);
    }

    public void testReceiveMessages() throws VradiException {
        this.mailingService.receiveMessages();
    }
}

