package com.jurismarches.vradi.services.managers;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * DateParser2.
 * 
 * Better replacement for {@link DateParser}.
 *
 * @author schorlet
 * @version $Revision: 904 $ $Date: 2010-05-11 11:49:41 +0200 (mar., 11 mai 2010) $
 * @since 10 mars 2010 12:02:21
 */
public class DateParser2 {
    private DateParser2() {}
    
    private static final String ND1 = "N.D.";
    private static final String ND2 = "---";
    
    private static final TimeZone timezone = TimeZone.getTimeZone("GMT");
    
    //public static final SimpleDateFormat defaultFormat = new SimpleDateFormat();
    // FIXME EC20100510 fix locale dependant tests
    public static final SimpleDateFormat defaultFormat = new SimpleDateFormat("", Locale.FRANCE);
    
    public static final SimpleDateFormat usFormat = new SimpleDateFormat("", Locale.US);
    
    /**
     * formats frequemments rencontrés.
     */
    public static final String[] frequentMasks = new String[] {
        // 10 avril 2010, à 12 heures
        "dd MMMM yyyy', à' HH 'heures'",
        // 5 mai 2010, à 12:00.
        "dd MMMM yyyy', à' HH:mm'.'",
        // 2 avril 2010, à 15 h 30
        "dd MMMM yyyy', à' HH 'h' mm",
        // 2010-04-02 12:00:00
        "yyyy-MM-dd HH:mm:ss",
    };
        
    /**
     * autres formats et variantes.
     */
    public static final String[] variantMasks = new String[] {
        // 23 mars 2010
        "dd MMMM yyyy",
        // 23 mars 2010.
        "dd MMMM yyyy'.'",
        
        // 10/03/2010 à 12:00
        "dd/MM/yyyy 'à' HH:mm",
        // 10/03/2010 à 12:00.
        "dd/MM/yyyy 'à' HH:mm'.'",
        // 10/03/2010 à 12 heures
        "dd/MM/yyyy 'à' HH 'heures'",
        // 10/03/2010
        "dd/MM/yyyy",
        
        // 2010-04-02 12:00:00
        "yyyy-MM-dd HH:mm:ss",
        // 2010-04-02 12:00
        "yyyy-MM-dd HH:mm",
        // 2008-12-21
        "yyyy-MM-dd",
        
        // 10 avril 2010 à 12 heures
        "dd MMMM yyyy 'à' HH 'heures'",
        
        // 5 mai 2010 à 12:00
        "dd MMMM yyyy 'à' HH:mm",
        // 5 mai 2010 à 12:00.
        "dd MMMM yyyy 'à' HH:mm'.'",
        // 5 mai 2010, à 12:00
        "dd MMMM yyyy', à' HH:mm",
        
        // 2 avril 2010 à 15 h 30
        "dd MMMM yyyy 'à' HH 'h' mm",
        // 2 avril 2010 à 15h30
        "dd MMMM yyyy 'à' HH'h'mm",
        // 2 avril 2010, à 15h30
        "dd MMMM yyyy', à' HH'h'mm",
        
        // 1.e.r avril 2010, à 17 heures
        "'1.e.r' MMMM yyyy', à' HH 'heures'",
        // 1.e.r avril 2010 à 17 heures
        "'1.e.r' MMMM yyyy 'à' HH 'heures'",
        // 1er avril 2010, à 17 heures
        "'1er' MMMM yyyy', à' HH 'heures'",
        // 1er avril 2010 à 17 heures
        "'1er' MMMM yyyy 'à' HH 'heures'"
    };
    
    /**
     * formats en Locale.US.
     */
    public static final String[] usMasks = new String[] {
        // Sun, 29 Nov 2009 22:07:29 +0100
        "E, d MMM yyyy HH:mm:ss Z"
    };
    
    public static Date parse(String source) {
        if (source == null) {
            return null;
        }
        
        String sourcetrim = source.trim();
        if (sourcetrim.isEmpty() || ND1.equals(sourcetrim) || ND2.equals(sourcetrim)) {
            return null;
        }
        
        Date date = parse(source, defaultFormat, frequentMasks);
        if (date == null) {
            date = parse(source, defaultFormat, variantMasks);
            
            if (date == null) {
                date = parse(source, usFormat, usMasks);
            }
        }
        
        return date;
    }
    
    public static Date parse(String source, SimpleDateFormat dateFormat, String... masks) {
        dateFormat.setTimeZone(timezone);
        for (String mask : masks) {
            try {
                dateFormat.applyPattern(mask);
                Date date = dateFormat.parse(source);
                return date;
            } catch (ParseException e) {
            }
        }
        
        return null;
    }
}
